/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.ontology;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import org.protege.editor.owl.ui.view.AbstractActiveOntologyViewComponent;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOntologyRenderingViewComponent
extends AbstractActiveOntologyViewComponent {
    private static final long serialVersionUID = 496671619048384054L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractOWLViewComponent.class);
    private JTextArea textArea;
    private Thread renderThread;

    @Override
    protected void initialiseOntologyView() throws Exception {
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.add(new JScrollPane(this.textArea));
        this.textArea.setFont(new Font("monospaced", 0, 12));
        this.textArea.setEditable(false);
        HierarchyListener hell = new HierarchyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    logger.trace("textArea.isShowing() = " + AbstractOntologyRenderingViewComponent.this.textArea.isShowing());
                    if (!AbstractOntologyRenderingViewComponent.this.textArea.isShowing()) {
                        JTextArea jTextArea = AbstractOntologyRenderingViewComponent.this.textArea;
                        synchronized (jTextArea) {
                            if (AbstractOntologyRenderingViewComponent.this.renderThread != null) {
                                AbstractOntologyRenderingViewComponent.this.renderThread.interrupt();
                                AbstractOntologyRenderingViewComponent.this.renderThread = null;
                            }
                            AbstractOntologyRenderingViewComponent.this.clearText();
                        }
                    }
                    try {
                        AbstractOntologyRenderingViewComponent.this.setText(AbstractOntologyRenderingViewComponent.this.getOWLModelManager().getActiveOntology());
                    }
                    catch (Exception e1) {
                        logger.error("setting text ", (Throwable)e1);
                    }
                }
            }
        };
        this.textArea.addHierarchyListener(hell);
        this.setText(this.getOWLModelManager().getActiveOntology());
    }

    @Override
    protected void disposeOntologyView() {
    }

    @Override
    protected void updateView(OWLOntology activeOntology) throws Exception {
        logger.debug("update view called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setText(final OWLOntology activeOntology) throws Exception {
        JTextArea jTextArea = this.textArea;
        synchronized (jTextArea) {
            if (this.renderThread != null) {
                this.renderThread.interrupt();
                this.renderThread = null;
            }
        }
        final Cursor oldCursor = this.getCursor();
        this.textArea.setCursor(Cursor.getPredefinedCursor(3));
        this.clearText();
        this.renderThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                int estimatedTextSize = AbstractOntologyRenderingViewComponent.this.estimateRenderedTextLength(activeOntology);
                TextAreaWriter textAreaWriter = new TextAreaWriter(this, AbstractOntologyRenderingViewComponent.this.textArea, estimatedTextSize);
                BufferedWriter w = new BufferedWriter(textAreaWriter);
                try {
                    AbstractOntologyRenderingViewComponent.this.renderOntology(activeOntology, w);
                    ((Writer)w).close();
                }
                catch (InterruptedIOException interruptedIOException) {
                    JTextArea jTextArea = AbstractOntologyRenderingViewComponent.this.textArea;
                    synchronized (jTextArea) {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractOntologyRenderingViewComponent.this.textArea.setCursor(oldCursor);
                                    logger.debug("set text done");
                                }
                            });
                        }
                        catch (InterruptedException | InvocationTargetException exception) {
                            // empty catch block
                        }
                        AbstractOntologyRenderingViewComponent.this.renderThread = null;
                    }
                }
                catch (Exception e) {
                    logger.error("error rendering ontology", (Throwable)e);
                    {
                        catch (Throwable throwable) {
                            JTextArea jTextArea = AbstractOntologyRenderingViewComponent.this.textArea;
                            synchronized (jTextArea) {
                                try {
                                    SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                                }
                                catch (InterruptedException | InvocationTargetException exception) {
                                    // empty catch block
                                }
                                AbstractOntologyRenderingViewComponent.this.renderThread = null;
                            }
                            throw throwable;
                        }
                    }
                    JTextArea jTextArea = AbstractOntologyRenderingViewComponent.this.textArea;
                    synchronized (jTextArea) {
                        try {
                            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                        }
                        catch (InterruptedException | InvocationTargetException exception) {
                            // empty catch block
                        }
                        AbstractOntologyRenderingViewComponent.this.renderThread = null;
                    }
                }
                JTextArea jTextArea = AbstractOntologyRenderingViewComponent.this.textArea;
                synchronized (jTextArea) {
                    try {
                        SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (InterruptedException | InvocationTargetException exception) {
                        // empty catch block
                    }
                    AbstractOntologyRenderingViewComponent.this.renderThread = null;
                }
            }
        };
        this.renderThread.setPriority(1);
        this.renderThread.setName(((Object)((Object)this)).getClass().getName());
        this.renderThread.start();
        logger.debug("returning from set text");
    }

    protected int estimateRenderedTextLength(OWLOntology activeOntology) {
        return activeOntology.getAxiomCount() * 80;
    }

    private void clearText() {
        PlainDocument newDoc = new PlainDocument();
        this.textArea.setDocument(newDoc);
        this.textArea.setText("Ontology Not Rendered");
    }

    protected abstract void renderOntology(OWLOntology var1, Writer var2) throws Exception;

    static class TextAreaWriter
    extends Writer {
        JTextArea jtextArea;
        Document originalDocument;
        Thread thread;
        CharInsertableGapContent content;
        int nextMessageIncrement;
        int nextMessageThreshold;

        TextAreaWriter(Thread thread, JTextArea jtextArea, int size) {
            this.nextMessageThreshold = this.nextMessageIncrement = 1000000;
            this.thread = thread;
            this.jtextArea = jtextArea;
            this.originalDocument = jtextArea.getDocument();
            this.content = new CharInsertableGapContent(size);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.thread == null) {
                return;
            }
            if (this.thread.isInterrupted()) {
                this.content = null;
                this.thread = null;
                throw new InterruptedIOException();
            }
            try {
                this.content.insertChars(this.content.length() - 1, cbuf, off, len);
                if (this.content.length() > this.nextMessageThreshold) {
                    this.nextMessageThreshold += this.nextMessageIncrement;
                    final String message = String.format("Rendering: %,9d chars", this.content.length());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (jtextArea.getDocument() == originalDocument) {
                                jtextArea.setText(message);
                            }
                        }
                    });
                }
            }
            catch (BadLocationException e1) {
                this.thread.interrupt();
                throw new IOException("Bad location in TextAreaWriter::write", e1);
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
            logger.trace("close called");
            if (this.thread != null && !this.thread.isInterrupted()) {
                this.thread = null;
                logger.trace("building doc ");
                final CharInsertableDocument doc = new CharInsertableDocument(this.content);
                logger.trace("built doc");
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            jtextArea.setDocument(doc);
                            logger.trace("set doc");
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    static class CharInsertableDocument
    extends PlainDocument {
        CharInsertableDocument(CharInsertableGapContent c) {
            super(c);
            AbstractDocument.DefaultDocumentEvent event = new AbstractDocument.DefaultDocumentEvent(this, 0, c.length(), DocumentEvent.EventType.INSERT);
            this.insertUpdate(event, null);
            event.end();
            this.fireInsertUpdate(event);
        }
    }

    static class CharInsertableGapContent
    extends GapContent {
        public CharInsertableGapContent(int size) {
            super(size);
        }

        public CharInsertableGapContent() {
        }

        public void insertChars(int position, char[] cbuf, int off, int len) throws BadLocationException {
            if (position > this.length() || position < 0) {
                throw new BadLocationException("Invalid insert", this.length());
            }
            if (off == 0) {
                this.replace(position, 0, cbuf, len);
            } else {
                char[] tmp = new char[len];
                System.arraycopy(cbuf, off, tmp, 0, len);
                this.replace(position, 0, tmp, len);
            }
        }
    }
}

