/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.ontology;

import com.google.common.base.Optional;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.NumberFormat;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.core.ui.util.AugmentedJTextField;
import org.protege.editor.core.ui.util.LinkLabel;
import org.protege.editor.owl.model.OntologyAnnotationContainer;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.refactor.ontology.EntityIRIUpdaterOntologyChangeStrategy;
import org.protege.editor.owl.ui.ontology.annotation.OWLOntologyAnnotationList;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.util.OWLOntologyChangeVisitorAdapter;

public class OWLOntologyAnnotationViewComponent
extends AbstractOWLViewComponent {
    private static final long serialVersionUID = 1252038674995535772L;
    public static final String ONTOLOGY_IRI_FIELD_LABEL = "Ontology IRI";
    public static final String ONTOLOGY_VERSION_IRI_FIELD_LABEL = "Ontology Version IRI";
    public static final URI ONTOLOGY_IRI_DOCUMENTATION = URI.create("http://www.w3.org/TR/2009/REC-owl2-syntax-20091027/#Ontology_IRI_and_Version_IRI");
    public static final URI VERSION_IRI_DOCUMENTATION = URI.create("http://www.w3.org/TR/2009/REC-owl2-syntax-20091027/#Versioning_of_OWL_2_Ontologies");
    private OWLModelManagerListener listener;
    private OWLOntologyAnnotationList list;
    private final AugmentedJTextField ontologyIRIField = new AugmentedJTextField("e.g http://www.example.com/ontologies/myontology");
    private final AugmentedJTextField ontologyVersionIRIField = new AugmentedJTextField("e.g. http://www.example.com/ontologies/myontology/1.0.0");
    private boolean updatingViewFromModel = false;
    private boolean updatingModelFromView = false;
    private OWLOntologyID initialOntologyID = null;
    private boolean ontologyIRIShowing = false;
    private final OWLOntologyChangeListener ontologyChangeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> owlOntologyChanges) throws OWLException {
            OWLOntologyAnnotationViewComponent.this.handleOntologyChanges(owlOntologyChanges);
        }
    };

    @Override
    protected void initialiseOWLView() throws Exception {
        this.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        JPanel ontologyIRIPanel = new JPanel(new GridBagLayout());
        this.add(ontologyIRIPanel, "North");
        Insets insets = new Insets(0, 4, 2, 0);
        ontologyIRIPanel.add((Component)new LinkLabel(ONTOLOGY_IRI_FIELD_LABEL, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLOntologyAnnotationViewComponent.this.showOntologyIRIDocumentation();
            }
        }), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 768, 0, insets, 0, 0));
        ontologyIRIPanel.add((Component)this.ontologyIRIField, new GridBagConstraints(1, 0, 1, 1, 100.0, 0.0, 512, 2, insets, 0, 0));
        this.ontologyIRIField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OWLOntologyAnnotationViewComponent.this.updateModelFromView();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OWLOntologyAnnotationViewComponent.this.updateModelFromView();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.ontologyIRIField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OWLOntologyAnnotationViewComponent.this.handleOntologyIRIFieldFocusLost();
            }

            @Override
            public void focusGained(FocusEvent e) {
                OWLOntologyAnnotationViewComponent.this.handleOntologyIRIFieldFocusGained();
            }
        });
        this.ontologyIRIShowing = this.ontologyIRIField.isShowing();
        this.ontologyIRIField.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                OWLOntologyAnnotationViewComponent.this.handleComponentHierarchyChanged();
            }
        });
        ontologyIRIPanel.add((Component)new LinkLabel(ONTOLOGY_VERSION_IRI_FIELD_LABEL, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLOntologyAnnotationViewComponent.this.showVersionIRIDocumentation();
            }
        }), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 768, 0, insets, 0, 0));
        ontologyIRIPanel.add((Component)this.ontologyVersionIRIField, new GridBagConstraints(1, 1, 1, 1, 100.0, 0.0, 512, 2, insets, 0, 0));
        this.ontologyVersionIRIField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OWLOntologyAnnotationViewComponent.this.updateModelFromView();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OWLOntologyAnnotationViewComponent.this.updateModelFromView();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        ontologyIRIPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
        this.list = new OWLOntologyAnnotationList(this.getOWLEditorKit());
        this.add(new JScrollPane((Component)((Object)this.list)));
        this.list.setRootObject(new OntologyAnnotationContainer(this.activeOntology()));
        this.listener = new OWLModelManagerListener(){

            @Override
            public void handleChange(OWLModelManagerChangeEvent event) {
                OWLOntologyAnnotationViewComponent.this.handleModelManagerChangeEvent(event);
            }
        };
        this.getOWLModelManager().addListener(this.listener);
        this.getOWLModelManager().addOntologyChangeListener(this.ontologyChangeListener);
        this.updateView();
    }

    private void handleComponentHierarchyChanged() {
        if (this.ontologyIRIShowing != this.ontologyIRIField.isShowing()) {
            this.ontologyIRIShowing = this.ontologyIRIField.isShowing();
            if (!this.ontologyIRIField.isShowing()) {
                this.handlePossibleOntologyIdUpdate();
            } else {
                this.handleOntologyIRIFieldActivated();
            }
        }
    }

    private void handleOntologyIRIFieldFocusGained() {
        this.handleOntologyIRIFieldActivated();
    }

    private void handleOntologyIRIFieldActivated() {
        this.initialOntologyID = this.getOWLModelManager().getActiveOntology().getOntologyID();
    }

    private void handleOntologyIRIFieldFocusLost() {
        this.handlePossibleOntologyIdUpdate();
    }

    private void handlePossibleOntologyIdUpdate() {
        boolean rename;
        EntityIRIUpdaterOntologyChangeStrategy changeStrategy;
        Set<OWLEntity> entities;
        OWLOntologyID id = this.createOWLOntologyIDFromView();
        if (this.isOntologyIRIChange(id) && !(entities = (changeStrategy = new EntityIRIUpdaterOntologyChangeStrategy()).getEntitiesToRename(this.activeOntology(), this.initialOntologyID, id)).isEmpty() && (rename = this.showConfirmRenameDialog(id, entities))) {
            List<OWLOntologyChange> changes = changeStrategy.getChangesForRename(this.activeOntology(), this.initialOntologyID, id);
            System.out.println("Generated " + changes.size() + " changes");
            System.out.println("Applying changes...");
            this.getOWLModelManager().applyChanges(changes);
            System.out.println("    ... applied changes.");
            this.initialOntologyID = id;
        }
    }

    private boolean showConfirmRenameDialog(OWLOntologyID id, Set<OWLEntity> entities) {
        String msg = this.getChangeEntityIRIsConfirmationMessage(id, entities);
        int ret = JOptionPane.showConfirmDialog((Component)((Object)this), msg, "Rename entities as well as ontology?", 0, 3);
        return ret == 0;
    }

    private boolean isOntologyIRIChange(OWLOntologyID id) {
        return this.initialOntologyID != null && id != null && !id.equals((Object)this.initialOntologyID) && !this.initialOntologyID.isAnonymous() && !id.isAnonymous();
    }

    private String getChangeEntityIRIsConfirmationMessage(OWLOntologyID id, Set<OWLEntity> entities) {
        return "<html><body>You have renamed the ontology from<br>" + ((IRI)this.initialOntologyID.getOntologyIRI().get()).toString() + "<br>" + "to<br>" + "" + ((IRI)id.getOntologyIRI().get()).toString() + ".<br>" + "<br>" + "<b>There are " + NumberFormat.getIntegerInstance().format(entities.size()) + " entities whose IRIs start with the original ontology IRI. Would you also like to rename these entities<br>" + "so that their IRIs start with the new ontology IRI?</b></body></html>";
    }

    private void handleModelManagerChangeEvent(OWLModelManagerChangeEvent event) {
        if (this.isUpdateTriggeringEvent(event)) {
            this.updateView();
        }
    }

    private boolean isUpdateTriggeringEvent(OWLModelManagerChangeEvent event) {
        return event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED) || event.isType(EventType.ONTOLOGY_LOADED) || event.isType(EventType.ONTOLOGY_RELOADED) || event.isType(EventType.ONTOLOGY_SAVED);
    }

    private void showVersionIRIDocumentation() {
        try {
            Desktop.getDesktop().browse(VERSION_IRI_DOCUMENTATION);
        }
        catch (IOException ex) {
            ErrorLogPanel.showErrorDialog((Throwable)ex);
        }
    }

    private void showOntologyIRIDocumentation() {
        try {
            Desktop.getDesktop().browse(ONTOLOGY_IRI_DOCUMENTATION);
        }
        catch (IOException ex) {
            ErrorLogPanel.showErrorDialog((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateViewFromModel() {
        this.updatingViewFromModel = true;
        try {
            OWLOntology activeOntology = this.getOWLEditorKit().getOWLModelManager().getActiveOntology();
            if (activeOntology.isAnonymous()) {
                if (!this.ontologyIRIField.getText().isEmpty()) {
                    this.ontologyIRIField.setText("");
                    if (this.ontologyVersionIRIField.getText().isEmpty()) {
                        this.ontologyVersionIRIField.setText("");
                    }
                }
            } else {
                Optional versionIRI;
                OWLOntologyID id = activeOntology.getOntologyID();
                Optional ontologyIRI = id.getOntologyIRI();
                String ontologyIRIString = ((IRI)ontologyIRI.get()).toString();
                if (ontologyIRI.isPresent() && !this.ontologyIRIField.getText().equals(ontologyIRIString)) {
                    this.ontologyIRIField.setText(ontologyIRIString);
                }
                if ((versionIRI = id.getVersionIRI()).isPresent()) {
                    String versionIRIString = ((IRI)versionIRI.get()).toString();
                    if (!this.ontologyVersionIRIField.getText().equals(versionIRIString)) {
                        this.ontologyVersionIRIField.setText(versionIRIString);
                    }
                } else {
                    this.ontologyVersionIRIField.setText("");
                    if (ontologyIRI.isPresent()) {
                        this.ontologyVersionIRIField.setGhostText("e.g. " + ontologyIRIString + (ontologyIRIString.endsWith("/") ? "1.0.0" : "/1.0.0"));
                    }
                }
            }
        }
        finally {
            this.updatingViewFromModel = false;
        }
    }

    private void updateModelFromView() {
        if (this.updatingViewFromModel) {
            return;
        }
        try {
            this.updatingModelFromView = true;
            OWLOntologyID id = this.createOWLOntologyIDFromView();
            if (id != null && !this.activeOntology().getOntologyID().equals((Object)id)) {
                this.getOWLModelManager().applyChange((OWLOntologyChange)new SetOntologyID(this.activeOntology(), id));
            }
        }
        finally {
            this.updatingModelFromView = false;
        }
    }

    private OWLOntology activeOntology() {
        return this.getOWLModelManager().getActiveOntology();
    }

    private OWLOntologyID createOWLOntologyIDFromView() {
        try {
            this.ontologyIRIField.clearErrorMessage();
            this.ontologyIRIField.clearErrorLocation();
            String ontologyIRIString = this.ontologyIRIField.getText().trim();
            if (ontologyIRIString.isEmpty()) {
                return new OWLOntologyID();
            }
            URI ontURI = new URI(ontologyIRIString);
            IRI ontologyIRI = IRI.create((URI)ontURI);
            String versionIRIString = this.ontologyVersionIRIField.getText().trim();
            if (versionIRIString.isEmpty()) {
                return new OWLOntologyID(Optional.of((Object)ontologyIRI), Optional.absent());
            }
            URI verURI = new URI(versionIRIString);
            IRI versionIRI = IRI.create((URI)verURI);
            return new OWLOntologyID(Optional.of((Object)ontologyIRI), Optional.of((Object)versionIRI));
        }
        catch (URISyntaxException e) {
            this.ontologyIRIField.setErrorMessage(e.getReason());
            this.ontologyIRIField.setErrorLocation(e.getIndex());
            return null;
        }
    }

    private void handleOntologyChanges(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            oWLOntologyChange.accept((OWLOntologyChangeVisitor)new OWLOntologyChangeVisitorAdapter(){

                public void visit(SetOntologyID change) {
                    OWLOntologyAnnotationViewComponent.this.updateView();
                }
            });
        }
    }

    private void updateView() {
        this.list.setRootObject(new OntologyAnnotationContainer(this.activeOntology()));
        this.updateViewFromModel();
    }

    @Override
    protected void disposeOWLView() {
        this.list.dispose();
        this.getOWLModelManager().removeListener(this.listener);
        this.getOWLModelManager().removeOntologyChangeListener(this.ontologyChangeListener);
    }
}

