/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.Color;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.metal.MetalTheme;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.protege.editor.core.BookMarkedURIManager;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.ProtegeProperties;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.EditorKitFactoryPlugin;
import org.protege.editor.core.editorkit.EditorKitManager;
import org.protege.editor.core.editorkit.RecentEditorKitManager;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.core.log.LogManager;
import org.protege.editor.core.log.LogViewImpl;
import org.protege.editor.core.platform.OSGi;
import org.protege.editor.core.platform.OSUtils;
import org.protege.editor.core.platform.PlatformArguments;
import org.protege.editor.core.platform.apple.ProtegeAppleApplication;
import org.protege.editor.core.plugin.PluginUtilities;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.core.ui.progress.BackgroundTaskManager;
import org.protege.editor.core.ui.tabbedpane.CloseableTabbedPaneUI;
import org.protege.editor.core.ui.util.ErrorMessage;
import org.protege.editor.core.ui.util.ProtegePlasticTheme;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.update.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtegeApplication
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(ProtegeApplication.class);
    public static final String BUNDLE_WITHOUT_PLUGIN_XML = "No-Plugin-XML";
    public static final String BUNDLE_DIR_PROP = "org.protege.plugin.dir";
    public static final String RUN_ONCE = "PROTEGE_OSGI_RUN_ONCE";
    public static final String ID = "org.protege.editor.core.application";
    public static final String LOOK_AND_FEEL_KEY = "LOOK_AND_FEEL_KEY";
    public static final String LOOK_AND_FEEL_CLASS_NAME = "LOOK_AND_FEEL_CLASS_NAME";
    private static BundleContext context;
    private List<URI> commandLineURIs;
    private static BackgroundTaskManager backgroundTaskManager;
    private static boolean quitting;
    private static LogManager logManager;

    public void start(final BundleContext context) {
        logManager.bind();
        context.addFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 1) {
                    ProtegeApplication.this.reallyStart(context);
                }
            }
        });
    }

    public void reallyStart(BundleContext context) {
        try {
            ProtegeApplication.context = context;
            this.displayPlatform();
            this.initApplication();
            if (OSUtils.isOSX()) {
                ProtegeAppleApplication.getInstance();
            }
            ProtegeManager.getInstance().initialise(this);
            this.startApplication();
        }
        catch (Throwable t) {
            logger.error("Exception caught starting Protege", t);
        }
    }

    public void stop(BundleContext context) throws Exception {
        BookMarkedURIManager.getInstance().dispose();
        RecentEditorKitManager.getInstance().save();
        RecentEditorKitManager.getInstance().dispose();
        PluginUtilities.getInstance().dispose();
        ProtegeManager.getInstance().dispose();
        logManager.unbind();
    }

    private void displayPlatform() {
        Bundle thisBundle = context.getBundle();
        Version v = PluginUtilities.getBundleVersion(thisBundle);
        logger.info(LogBanner.start("Prot\u00e9g\u00e9"));
        logger.info("Prot\u00e9g\u00e9 Desktop");
        logger.info("Version {}.{}.{}, Build {}", new Object[]{v.getMajor(), v.getMinor(), v.getMicro(), v.getQualifier()});
        logger.info("");
        logger.info("");
        logger.info(LogBanner.start("Platform"));
        logger.info("Java: JVM {}  Memory: {}M", (Object)System.getProperty("java.runtime.version"), (Object)ProtegeApplication.getMaxMemoryInMegaBytes());
        logger.info("Language: {}, Country: {}", (Object)ProtegeApplication.getLang(), (Object)ProtegeApplication.getCountry());
        logger.info("Framework: {} ({}) ", (Object)ProtegeApplication.getFramework(), (Object)ProtegeApplication.getFrameworkVersion());
        logger.info("OS: {} ({})", (Object)ProtegeApplication.getOsName(), (Object)ProtegeApplication.getOsVersion());
        logger.info("Processor: {}\n", (Object)ProtegeApplication.getProcessor());
        logger.info(LogBanner.end());
        logger.info(LogBanner.start("Plugins"));
        int pluginCount = 0;
        for (Bundle plugin : context.getBundles()) {
            if (!ProtegeApplication.isPlugin(plugin)) continue;
            if (ProtegeApplication.isActive(plugin)) {
                logger.info("Plugin: {} ({})", (Object)ProtegeApplication.getNiceBundleName(plugin), (Object)plugin.getVersion());
                ++pluginCount;
                continue;
            }
            logger.warn("Plugin: {} ({}) was not successfully started.  Please see the Prot\u00e9g\u00e9 log for more details.", (Object)ProtegeApplication.getNiceBundleName(plugin), (Object)plugin.getVersion());
        }
        if (pluginCount == 0) {
            logger.info("No plugins installed");
        }
        logger.info(LogBanner.end());
        for (Bundle plugin : context.getBundles()) {
            if (!ProtegeApplication.isPlugin(plugin)) continue;
            this.pluginSanityCheck(plugin);
        }
    }

    private static String getProcessor() {
        return context.getProperty("org.osgi.framework.processor");
    }

    private static String getOsVersion() {
        return context.getProperty("org.osgi.framework.os.version");
    }

    private static String getOsName() {
        return context.getProperty("org.osgi.framework.os.name");
    }

    private static String getFrameworkVersion() {
        return context.getProperty("org.osgi.framework.version");
    }

    private static String getFramework() {
        return context.getProperty("org.osgi.framework.vendor");
    }

    private static String getCountry() {
        return Locale.getDefault().getCountry();
    }

    private static String getLang() {
        return Locale.getDefault().getLanguage();
    }

    private static long getMaxMemoryInMegaBytes() {
        return Runtime.getRuntime().maxMemory() / 1000000L;
    }

    private boolean pluginSanityCheck(Bundle b) {
        boolean hasPluginXml;
        boolean passed = true;
        boolean bl = hasPluginXml = b.getResource("/plugin.xml") != null;
        if (b.getHeaders().get(BUNDLE_WITHOUT_PLUGIN_XML) == null && !hasPluginXml) {
            logger.info("\t" + ProtegeApplication.getNiceBundleName(b) + " Plugin has no plugin.xml resource");
            passed = false;
        }
        if (hasPluginXml && !ProtegeApplication.isSingleton(b)) {
            logger.warn("\t" + ProtegeApplication.getNiceBundleName(b) + " plugin is not a singleton so its plugin.xml will not be seen by the registry.");
            passed = false;
        }
        return passed;
    }

    public static boolean isActive(Bundle b) {
        return b.getState() == 32;
    }

    public static boolean isPlugin(Bundle b) {
        String location = b.getLocation();
        return location != null && location.contains("plugin");
    }

    public static boolean isSingleton(Bundle b) {
        StringBuffer singleton1 = new StringBuffer("singleton");
        singleton1.append(":=true");
        StringBuffer singleton2 = new StringBuffer("singleton");
        singleton2.append(":=\"true\"");
        return ((String)b.getHeaders().get("Bundle-SymbolicName")).contains(singleton1.toString()) || ((String)b.getHeaders().get("Bundle-SymbolicName")).contains(singleton2.toString());
    }

    public static String getNiceBundleName(Bundle b) {
        String name = (String)b.getHeaders().get("Bundle-Name");
        if (name == null) {
            name = b.getSymbolicName();
        }
        return name;
    }

    protected ProtegeApplication initApplication() throws Exception {
        PluginUtilities.getInstance().initialise(context);
        ProtegeApplication.loadDefaults();
        this.initializeLookAndFeel();
        this.setupExceptionHandler();
        this.processCommandLineURIs();
        ProtegeApplication.loadRecentEditorKits();
        return this;
    }

    private static void loadDefaults() {
        ProtegeProperties.getInstance().put("org.protege.classcolor", "CC9F2A");
        ProtegeProperties.getInstance().put("org.protege.propertycolor", "306FA2");
        ProtegeProperties.getInstance().put("org.protege.objectpropertycolor", "306FA2");
        ProtegeProperties.getInstance().put("org.protege.datapropertycolor", "6B8E23");
        ProtegeProperties.getInstance().put("org.protege.individualcolor", "541852");
        ProtegeProperties.getInstance().put("org.protege.ontologycolor", "6B47A2");
        ProtegeProperties.getInstance().put("org.protege.annotationscolor", "719FA0");
        ProtegeProperties.getInstance().put("org.protege.datatypecolor", "6B8E23  ");
        ProtegeProperties.getInstance().put("org.protege.classcategory", "Class");
        ProtegeProperties.getInstance().put("org.protege.objectpropertycategory", "Object property");
        ProtegeProperties.getInstance().put("org.protege.datapropertycategory", "Data property");
        ProtegeProperties.getInstance().put("org.protege.annotationpropertycategory", "Annotation property");
        ProtegeProperties.getInstance().put("org.protege.individualcategory", "Individual");
        ProtegeProperties.getInstance().put("org.protege.datatypecategory", "Datatype");
        ProtegeProperties.getInstance().put("org.protege.ontologycategory", "Ontology");
        ProtegeProperties.getInstance().put("org.protege.querycategory", "Query");
        ProtegeProperties.getInstance().put("org.protege.differencecategory", "Ontology comparison");
    }

    private static void loadRecentEditorKits() {
        RecentEditorKitManager.getInstance().load();
    }

    private void initializeLookAndFeel() {
        if (System.getProperty("swing.defaultlaf") == null) {
            String defaultLAFClassName = OSUtils.isOSX() ? UIManager.getSystemLookAndFeelClassName() : "com.jgoodies.looks.plastic.PlasticLookAndFeel";
            Preferences p = PreferencesManager.getInstance().getApplicationPreferences(LOOK_AND_FEEL_KEY);
            String lafClsName = p.getString(LOOK_AND_FEEL_CLASS_NAME, defaultLAFClassName);
            try {
                UIDefaults defaults = UIManager.getDefaults();
                if (lafClsName.equals(PlasticLookAndFeel.class.getName())) {
                    PlasticLookAndFeel.setCurrentTheme((MetalTheme)((Object)new ProtegePlasticTheme()));
                    UIManager.put("ClassLoader", PlasticLookAndFeel.class.getClassLoader());
                    LookAndFeel lookAndFeel = (LookAndFeel)Class.forName(lafClsName).newInstance();
                    UIManager.setLookAndFeel(lookAndFeel);
                } else {
                    UIManager.put("ClassLoader", this.getClass().getClassLoader());
                    UIManager.setLookAndFeel(lafClsName);
                }
                this.setupDefaults(defaults);
            }
            catch (Exception e) {
                logger.error("An error occurred during Look&Feel initialization", (Throwable)e);
            }
        }
    }

    private void setupDefaults(UIDefaults defaults) {
        defaults.put("TabbedPaneUI", CloseableTabbedPaneUI.class.getName());
        Color borderColor = new Color(220, 220, 220);
        MatteBorder commonBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, borderColor);
        defaults.put("ScrollPane.border", BorderFactory.createCompoundBorder(commonBorder, BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        defaults.put("TextArea.border", commonBorder);
        defaults.put("Spinner.border", commonBorder);
        defaults.put("TextField.border", BorderFactory.createCompoundBorder(commonBorder, BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    }

    private void setupExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.error("Uncaught Exception in thread '{}'", (Object)t.getName(), (Object)e);
            }
        });
    }

    private void processCommandLineURIs() {
        try {
            this.commandLineURIs = new ArrayList<URI>();
            for (String arg : PlatformArguments.getArguments(context)) {
                File f = new File(arg);
                if (f.exists()) {
                    this.commandLineURIs.add(f.toURI());
                    continue;
                }
                try {
                    URI uri = new URI(arg);
                    this.commandLineURIs.add(uri);
                }
                catch (URISyntaxException e) {
                    logger.error("An error occurred when processing the command line argument: {}", (Object)arg, (Object)e);
                }
            }
        }
        catch (Throwable t) {
            logger.warn("Error processing command line arguments " + t);
        }
    }

    private void startApplication() throws Exception {
        if (this.commandLineURIs != null && !this.commandLineURIs.isEmpty()) {
            for (URI uri : this.commandLineURIs) {
                this.createAndSetupDefaultEditorKit(uri);
            }
        } else {
            this.createAndSetupDefaultEditorKit();
        }
        this.checkForUpdates();
    }

    private void checkForUpdates() {
        try {
            logger.info(LogBanner.start("Auto-update Check"));
            if (!PluginManager.getInstance().isAutoUpdateEnabled()) {
                logger.info("Auto-update is disabled");
                return;
            }
            if (this.hasAutoUpdateBeenRunToday()) {
                logger.info("Auto-update has been performed today.  Not performing it again.");
                return;
            }
            logger.info("Auto-update has not been performed today.  Running it.");
            PluginManager.getInstance().runAutoUpdate();
            context.addFrameworkListener(new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 1) {
                        context.removeFrameworkListener((FrameworkListener)this);
                    }
                }
            });
        }
        finally {
            logger.info(LogBanner.end());
        }
    }

    private boolean hasAutoUpdateBeenRunToday() {
        Date lastRun = PluginManager.getInstance().getLastAutoUpdateDate();
        logger.info("Auto-update last performed: {}", (Object)lastRun);
        Date startOfToday = ProtegeApplication.getStartOfToday();
        return lastRun.after(startOfToday);
    }

    private static Date getStartOfToday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private void createAndSetupDefaultEditorKit() {
        try {
            ProtegeManager pm = ProtegeManager.getInstance();
            List<EditorKitFactoryPlugin> editorKitFactoryPlugins = pm.getEditorKitFactoryPlugins();
            if (!editorKitFactoryPlugins.isEmpty()) {
                EditorKitFactoryPlugin defaultPlugin = editorKitFactoryPlugins.get(0);
                pm.createAndSetupNewEditorKit(defaultPlugin);
            } else {
                ErrorMessage.showErrorMessage("Fatal Error", "An error occurred that prevented Prot\u00e9g\u00e9 from starting");
            }
        }
        catch (Exception e) {
            ErrorLogPanel.showErrorDialog(e);
        }
    }

    private void createAndSetupDefaultEditorKit(URI uri) {
        try {
            ProtegeManager pm = ProtegeManager.getInstance();
            List<EditorKitFactoryPlugin> editorKitFactoryPlugins = pm.getEditorKitFactoryPlugins();
            if (!editorKitFactoryPlugins.isEmpty()) {
                EditorKitFactoryPlugin defaultPlugin = editorKitFactoryPlugins.get(0);
                pm.createAndSetupNewEditorKit(defaultPlugin, uri);
            } else {
                ErrorMessage.showErrorMessage("Fatal Error", "An error occurred that prevented Prot\u00e9g\u00e9 from starting");
            }
        }
        catch (Exception e) {
            ErrorLogPanel.showErrorDialog(e);
        }
    }

    public static BundleContext getContext() {
        return context;
    }

    public static BackgroundTaskManager getBackgroundTaskManager() {
        return backgroundTaskManager;
    }

    public static boolean handleQuit() {
        quitting = true;
        EditorKitManager eKitMngr = ProtegeManager.getInstance().getEditorKitManager();
        for (EditorKit eKit : eKitMngr.getEditorKits()) {
            Workspace wSpace = eKit.getWorkspace();
            if (eKitMngr.getWorkspaceManager().doClose(wSpace)) continue;
            quitting = false;
            return quitting;
        }
        try {
            boolean forceExit = !OSGi.systemExitHandledByLauncher();
            context.getBundle(0L).stop();
            if (forceExit) {
                Thread.sleep(1000L);
                System.exit(0);
            }
        }
        catch (Throwable t) {
            logger.error("An error occurred when shutting down Prot\u00e9g\u00e9.", t);
        }
        return true;
    }

    public void handleClose() {
        EditorKitManager eKitMngr;
        if (!quitting && (eKitMngr = ProtegeManager.getInstance().getEditorKitManager()).getEditorKitCount() == 0) {
            ProtegeApplication.handleQuit();
        }
    }

    public void editURI(URI uri) throws Exception {
        ProtegeManager pm = ProtegeManager.getInstance();
        for (EditorKitFactoryPlugin plugin : pm.getEditorKitFactoryPlugins()) {
            if (!plugin.newInstance().canLoad(uri)) continue;
            pm.loadAndSetupEditorKitFromURI(plugin, uri);
            break;
        }
    }

    public static void handleRestart() {
    }

    public static void showLogView() {
        logManager.showLogView();
    }

    public static LogManager getLogManager() {
        return logManager;
    }

    static {
        backgroundTaskManager = new BackgroundTaskManager();
        quitting = false;
        logManager = new LogManager(new LogViewImpl());
    }
}

