/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.protege.editor.core.OntologyRepository;
import org.protege.editor.core.OntologyRepositoryEntry;
import org.protege.editor.core.OntologyRepositoryFactory;
import org.protege.editor.core.OntologyRepositoryFactoryPlugin;
import org.protege.editor.core.OntologyRepositoryFactoryPluginLoader;
import org.protege.editor.core.OntologyRepositoryManager;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.EditorKitDescriptor;
import org.protege.editor.core.editorkit.EditorKitFactory;
import org.protege.editor.core.editorkit.EditorKitFactoryPlugin;
import org.protege.editor.core.editorkit.EditorKitFactoryPluginLoader;
import org.protege.editor.core.editorkit.EditorKitManager;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.ui.workspace.WorkspaceFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtegeManager {
    public static final Logger logger = LoggerFactory.getLogger(ProtegeManager.class);
    private static ProtegeManager instance;
    private EditorKitManager editorKitManager;
    private Map<EditorKitFactoryPlugin, EditorKitFactory> editorKitFactoriesMap = new HashMap<EditorKitFactoryPlugin, EditorKitFactory>();
    private ProtegeApplication application;
    private WeakReference<EditorKit> firstEditorKit;

    private ProtegeManager() {
        EditorKitFactoryPluginLoader loader = new EditorKitFactoryPluginLoader();
        for (EditorKitFactoryPlugin plugin : loader.getPlugins()) {
            this.editorKitFactoriesMap.put(plugin, null);
        }
        this.setupRepositories();
    }

    public static synchronized ProtegeManager getInstance() {
        if (instance == null) {
            instance = new ProtegeManager();
        }
        return instance;
    }

    public void dispose() {
        for (OntologyRepository repository : OntologyRepositoryManager.getManager().getOntologyRepositories()) {
            try {
                repository.dispose();
            }
            catch (Exception e) {
                logger.warn("An error occurred whilst trying dispose of the repository '{}': {}", (Object)repository.getName(), (Object)e);
            }
        }
        instance = null;
    }

    protected void initialise(ProtegeApplication application) {
        this.application = application;
    }

    public ProtegeApplication getApplication() {
        return this.application;
    }

    public EditorKitManager getEditorKitManager() {
        if (this.editorKitManager == null) {
            this.editorKitManager = new EditorKitManager();
        }
        return this.editorKitManager;
    }

    public WorkspaceFrame getFrame(Workspace workspace) {
        return this.getEditorKitManager().getWorkspaceManager().getFrame(workspace);
    }

    public List<EditorKitFactoryPlugin> getEditorKitFactoryPlugins() {
        return new ArrayList<EditorKitFactoryPlugin>(this.editorKitFactoriesMap.keySet());
    }

    public boolean createAndSetupNewEditorKit(EditorKitFactoryPlugin plugin) throws Exception {
        EditorKitFactory editorKitFactory = this.getEditorKitFactory(plugin);
        return this.createAndSetupNewEditorKit(editorKitFactory) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditorKit createAndSetupNewEditorKit(EditorKitFactory editorKitFactory) throws Exception {
        if (editorKitFactory != null) {
            boolean success = false;
            EditorKit editorKit = editorKitFactory.createEditorKit();
            try {
                if (editorKit.handleNewRequest()) {
                    this.getEditorKitManager().addEditorKit(editorKit);
                    success = true;
                    if (this.getEditorKitManager().getEditorKitCount() == 1) {
                        this.firstEditorKit = new WeakReference<EditorKit>(editorKit);
                    }
                    EditorKit editorKit2 = editorKit;
                    return editorKit2;
                }
            }
            finally {
                if (!success) {
                    editorKit.dispose();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditorKit createAndSetupNewEditorKit(EditorKitFactory editorKitFactory, URI uri) throws Exception {
        if (editorKitFactory != null) {
            boolean success = false;
            EditorKit editorKit = editorKitFactory.createEditorKit();
            try {
                if (editorKit.handleLoadFrom(uri)) {
                    this.getEditorKitManager().addEditorKit(editorKit);
                    success = true;
                    if (this.getEditorKitManager().getEditorKitCount() == 1) {
                        this.firstEditorKit = new WeakReference<EditorKit>(editorKit);
                    }
                    EditorKit editorKit2 = editorKit;
                    return editorKit2;
                }
            }
            finally {
                if (!success) {
                    editorKit.dispose();
                }
            }
        }
        return null;
    }

    public boolean createAndSetupNewEditorKit(EditorKitFactoryPlugin plugin, URI uri) throws Exception {
        EditorKitFactory editorKitFactory = this.getEditorKitFactory(plugin);
        return this.createAndSetupNewEditorKit(editorKitFactory, uri) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openAndSetupEditorKit(EditorKitFactoryPlugin plugin) throws Exception {
        EditorKitFactory editorKitFactory = this.getEditorKitFactory(plugin);
        if (editorKitFactory != null) {
            boolean success = false;
            EditorKit editorKit = editorKitFactory.createEditorKit();
            try {
                if (editorKit.handleLoadRequest()) {
                    this.getEditorKitManager().addEditorKit(editorKit);
                    success = true;
                    this.closeFirstEditorKitIfNotModified();
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (!success) {
                    editorKit.dispose();
                }
            }
        }
        return false;
    }

    private void closeFirstEditorKitIfNotModified() {
        EditorKit firstEditorKit = (EditorKit)this.firstEditorKit.get();
        if (firstEditorKit == null) {
            return;
        }
        EditorKitManager editorKitManager = this.getEditorKitManager();
        if (!firstEditorKit.hasModifiedDocument()) {
            editorKitManager.getWorkspaceManager().doClose(firstEditorKit.getWorkspace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadAndSetupEditorKitFromURI(EditorKitFactoryPlugin plugin, URI uri) throws Exception {
        EditorKitFactory editorKitFactory = this.getEditorKitFactory(plugin);
        if (editorKitFactory != null) {
            boolean success = false;
            EditorKit editorKit = editorKitFactory.createEditorKit();
            try {
                if (editorKit.handleLoadFrom(uri)) {
                    this.getEditorKitManager().addEditorKit(editorKit);
                    this.closeFirstEditorKitIfNotModified();
                    success = true;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (!success) {
                    editorKit.dispose();
                }
            }
        }
        return false;
    }

    public boolean openAndSetupRecentEditorKit(EditorKitDescriptor editorKitDescriptor) throws Exception {
        for (EditorKitFactoryPlugin plugin : this.getEditorKitFactoryPlugins()) {
            EditorKitFactory editorKitFactory;
            EditorKit editorKit;
            if (!plugin.getId().equals(editorKitDescriptor.getEditorKitFactoryID()) || !(editorKit = (editorKitFactory = this.getEditorKitFactory(plugin)).createEditorKit()).handleLoadRecentRequest(editorKitDescriptor)) continue;
            this.getEditorKitManager().addEditorKit(editorKit);
            this.closeFirstEditorKitIfNotModified();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadAndSetupEditorKitFromRepository(OntologyRepository repository, OntologyRepositoryEntry entry) throws Exception {
        for (EditorKitFactoryPlugin plugin : this.getEditorKitFactoryPlugins()) {
            String id = plugin.getId();
            if (!id.equals(entry.getEditorKitId())) continue;
            boolean success = false;
            EditorKitFactory editorKitFactory = this.getEditorKitFactory(plugin);
            if (editorKitFactory != null) {
                EditorKit editorKit = editorKitFactory.createEditorKit();
                try {
                    entry.configureEditorKit(editorKit);
                    if (editorKit.handleLoadFrom(entry.getPhysicalURI())) {
                        this.getEditorKitManager().addEditorKit(editorKit);
                        this.closeFirstEditorKitIfNotModified();
                        success = true;
                    }
                }
                finally {
                    entry.restoreEditorKit(editorKit);
                    if (!success) {
                        editorKit.dispose();
                    }
                }
            }
            return success;
        }
        return false;
    }

    public void saveEditorKit(EditorKit editorKit) throws Exception {
        editorKit.handleSave();
    }

    public void saveEditorKitAs(EditorKit editorKit) throws Exception {
        editorKit.handleSaveAs();
        this.getFrame(editorKit.getWorkspace()).updateTitle();
    }

    public void disposeOfEditorKit(EditorKit editorKit) {
        ProtegeManager.getInstance().getEditorKitManager().removeEditorKit(editorKit);
        try {
            editorKit.dispose();
        }
        catch (Exception e) {
            logger.warn("An error occurred whilst trying to dispose of the editor kit '{}': {}", (Object)editorKit.getId(), (Object)e);
        }
        System.gc();
        this.application.handleClose();
    }

    public EditorKitFactory getEditorKitFactory(EditorKitFactoryPlugin plugin) {
        EditorKitFactory editorKitFactory = this.editorKitFactoriesMap.get(plugin);
        if (editorKitFactory != null) {
            return editorKitFactory;
        }
        EditorKitFactory editorKitFactory1 = plugin.newInstance();
        this.editorKitFactoriesMap.put(plugin, editorKitFactory1);
        return editorKitFactory1;
    }

    private void setupRepositories() {
        OntologyRepositoryFactoryPluginLoader loader = new OntologyRepositoryFactoryPluginLoader();
        for (OntologyRepositoryFactoryPlugin plugin : loader.getPlugins()) {
            try {
                OntologyRepositoryFactory factory = (OntologyRepositoryFactory)plugin.newInstance();
                factory.initialise();
                OntologyRepositoryManager.getManager().addRepository(factory.createRepository());
            }
            catch (Throwable e) {
                logger.warn("An error occurred whilst attempting to load an ontology repository.  Ontology Repository Plugin: ", (Object)plugin.getId(), (Object)e);
            }
        }
    }
}

