/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.editorkit;

import java.util.HashMap;
import java.util.Map;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.EditorKitFactory;
import org.protege.editor.core.editorkit.plugin.EditorKitHook;
import org.protege.editor.core.editorkit.plugin.EditorKitHookPlugin;
import org.protege.editor.core.editorkit.plugin.EditorKitHookPluginLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEditorKit<T extends EditorKitFactory>
implements EditorKit {
    private final Logger logger = LoggerFactory.getLogger(AbstractEditorKit.class);
    private Map<Object, Disposable> objects = new HashMap<Object, Disposable>();
    private T editorKitFactory;

    public AbstractEditorKit(T editorKitFactory) {
        this.editorKitFactory = editorKitFactory;
        this.initialise();
        this.initialiseCompleted();
    }

    protected abstract void initialise();

    protected void initialiseCompleted() {
        for (EditorKitHookPlugin editorKitHookPlugin : new EditorKitHookPluginLoader(this).getPlugins()) {
            try {
                EditorKitHook instance = (EditorKitHook)editorKitHookPlugin.newInstance();
                instance.initialise();
                this.put(editorKitHookPlugin.getId(), instance);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void put(Object key, Disposable value) {
        this.objects.put(key, value);
    }

    @Override
    public Disposable get(Object key) {
        return this.objects.get(key);
    }

    public T getEditorKitFactory() {
        return this.editorKitFactory;
    }

    @Override
    public void dispose() {
        for (Disposable object : this.objects.values()) {
            try {
                object.dispose();
            }
            catch (Exception e) {
                this.logger.error("An error occurred whilst disposing of an Editor Kit object.  Object: ", (Object)object, (Object)e);
            }
        }
        this.objects.clear();
    }
}

