/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.protege.editor.core.log.LogLevel;
import org.protege.editor.core.log.ThrowableInfo;

public class LogRecord {
    private final LogLevel logLevel;
    private final long timestamp;
    private final String formattedMessage;
    private final Optional<ThrowableInfo> throwableInfo;
    private final String threadName;

    public LogRecord(LogLevel logLevel, long timestamp, String formattedMessage, Optional<ThrowableInfo> throwableInfo, String threadName) {
        this.logLevel = (LogLevel)((Object)Preconditions.checkNotNull((Object)((Object)logLevel)));
        this.timestamp = timestamp;
        this.formattedMessage = (String)Preconditions.checkNotNull((Object)formattedMessage);
        this.throwableInfo = (Optional)Preconditions.checkNotNull(throwableInfo);
        this.threadName = (String)Preconditions.checkNotNull((Object)threadName);
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    public Optional<ThrowableInfo> getThrowableInfo() {
        return this.throwableInfo;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.logLevel, this.timestamp, this.formattedMessage, this.throwableInfo, this.threadName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LogRecord)) {
            return false;
        }
        LogRecord other = (LogRecord)obj;
        return this.logLevel == other.logLevel && this.timestamp == other.timestamp && this.formattedMessage.equals(other.formattedMessage) && this.throwableInfo.equals(other.throwableInfo) && this.threadName.equals(other.threadName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LogRecord").addValue((Object)this.logLevel).addValue(this.timestamp).addValue((Object)this.formattedMessage).addValue((Object)this.threadName).toString();
    }
}

