/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import java.awt.Color;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.protege.editor.core.log.LogLevel;
import org.protege.editor.core.log.LogRecord;
import org.protege.editor.core.log.ThrowableInfo;

public class LogRecordRenderer
implements ListCellRenderer<LogRecord> {
    private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private static final Border border = BorderFactory.createEmptyBorder(2, 0, 2, 0);

    @Override
    public Component getListCellRendererComponent(JList<? extends LogRecord> list, LogRecord record, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, record, index, isSelected, cellHasFocus);
        String formattedText = this.getFormattedText(record);
        label.setText(formattedText);
        if (!isSelected) {
            if (record.getFormattedMessage().startsWith("---") && record.getFormattedMessage().endsWith("---")) {
                label.setForeground(Color.GRAY);
            } else if (record.getLogLevel() == LogLevel.ERROR) {
                label.setForeground(new Color(220, 0, 0));
            } else if (record.getLogLevel() == LogLevel.WARN) {
                label.setForeground(new Color(255, 135, 0));
            } else if (record.getLogLevel() == LogLevel.DEBUG) {
                label.setForeground(Color.LIGHT_GRAY);
            }
        }
        label.setBorder(border);
        return label;
    }

    private String getFormattedText(LogRecord record) {
        String firstLine = String.format("%7s  %s  %s", new Object[]{record.getLogLevel(), this.getTimestampRendering(record.getTimestamp()), record.getFormattedMessage()});
        if (!record.getThrowableInfo().isPresent()) {
            return firstLine;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><span style=\"font-weight: bold;\">");
        sb.append(firstLine);
        sb.append("</span><br>\n");
        ThrowableInfo throwableInfo = record.getThrowableInfo().get();
        LogRecordRenderer.renderThrowableInfo(sb, throwableInfo, 0);
        sb.append("</body></html>");
        return sb.toString().replace(" ", "&nbsp;");
    }

    private static void renderThrowableInfo(StringBuilder sb, ThrowableInfo throwableInfo, int depth) {
        int padding = depth + 1;
        LogRecordRenderer.pad(sb, padding);
        sb.append(throwableInfo.getClassName());
        sb.append("<br>\n");
        for (StackTraceElement element : throwableInfo.getStackTrace()) {
            LogRecordRenderer.pad(sb, padding);
            sb.append(element);
            sb.append("<br>\n");
        }
        Optional<ThrowableInfo> cause = throwableInfo.getCause();
        if (cause.isPresent()) {
            LogRecordRenderer.pad(sb, padding);
            sb.append("Caused by:<br>\n");
            LogRecordRenderer.renderThrowableInfo(sb, cause.get(), depth + 1);
        }
    }

    private static void pad(StringBuilder sb, int padding) {
        sb.append("                ");
        for (int i = 0; i < padding; ++i) {
            sb.append("        ");
        }
    }

    private String getTimestampRendering(long timestamp) {
        Date date = new Date(timestamp);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.format("%02d:%02d:%02d", calendar.get(11), calendar.get(12), calendar.get(13));
    }
}

