/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.protege.editor.core.log.LogRecord;
import org.protege.editor.core.log.LogRecordModel;
import org.protege.editor.core.log.LogRecordRenderer;
import org.protege.editor.core.log.LogView;

public class LogViewImpl
implements LogView {
    private final JComponent view = new JPanel(new BorderLayout());
    private final LogRecordModel logRecordModel;

    public LogViewImpl() {
        this.view.setPreferredSize(new Dimension(800, 600));
        this.logRecordModel = new LogRecordModel();
        JList<LogRecord> list = new JList<LogRecord>(this.logRecordModel);
        this.view.add(new JScrollPane(list));
        list.setFont(new Font("monospaced", 0, 12));
        list.setCellRenderer(new LogRecordRenderer());
    }

    @Override
    public JComponent asJComponent() {
        return this.view;
    }

    @Override
    public void clearView() {
        this.logRecordModel.clear();
    }

    @Override
    public void append(LogRecord logRecord) {
        SwingUtilities.invokeLater(() -> this.logRecordModel.append(logRecord));
    }
}

