/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.error;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.protege.editor.core.ui.error.ErrorLog;
import org.protege.editor.core.ui.error.SendErrorReportHandler;

public class ErrorLogPanel
extends JPanel {
    private static final long serialVersionUID = -8745982593246886108L;
    private ErrorLog errorLog;
    private JTextArea textArea;
    private SendErrorReportHandler errorReportHandler;

    public ErrorLogPanel(ErrorLog errorLog, SendErrorReportHandler handler) {
        this.errorLog = errorLog;
        this.errorReportHandler = handler;
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("monospaced", 0, 12));
        JPanel contentPane = new JPanel(new BorderLayout(7, 7));
        contentPane.add(new JScrollPane(this.textArea));
        if (handler != null) {
            JPanel buttonPanel = new JPanel(new BorderLayout());
            buttonPanel.add((Component)new JButton(new AbstractAction("Clear Errors"){
                private static final long serialVersionUID = 6061428199099888086L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ErrorLogPanel.this.handleSendErrorReport()) {
                        ErrorLogPanel.this.errorLog.clear();
                        ErrorLogPanel.this.fillLog();
                        ErrorLogPanel.this.repaint();
                    }
                }
            }), "West");
            contentPane.add((Component)buttonPanel, "South");
        }
        this.add((Component)contentPane, "Center");
        this.fillLog();
    }

    private boolean handleSendErrorReport() {
        return this.errorReportHandler != null && this.errorReportHandler.sendErrorReport(this.errorLog);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }

    @Override
    public void setVisible(boolean b) {
        this.fillLog();
        Container parent = this.getParent();
        if (parent != null) {
            int w = (parent.getWidth() - this.getWidth()) / 2;
            int h = (parent.getHeight() - this.getHeight()) / 2;
            this.setLocation(w, h);
        }
        super.setVisible(b);
    }

    public void fillLog() {
        this.textArea.setText("");
        for (ErrorLog.ErrorLogEntry entry : this.errorLog.getEntries()) {
            this.textArea.append(entry.toString());
            this.textArea.append("---------------------------------------------------------------------------------------------------\n\n");
        }
    }

    protected ErrorLog getErrorLog() {
        return this.errorLog;
    }

    public static void showErrorDialog(Throwable throwable) {
        ErrorLog errorLog = new ErrorLog();
        if (throwable != null) {
            errorLog.logError(throwable);
        }
        ErrorLogPanel panel = new ErrorLogPanel(errorLog, null);
        JOptionPane.showMessageDialog(null, panel, "Error", 0);
    }
}

