/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.menu;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.platform.OSUtils;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.core.ui.action.ProtegeDynamicAction;
import org.protege.editor.core.ui.menu.MenuActionPlugin;
import org.protege.editor.core.ui.menu.MenuActionPluginLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuBuilder {
    private final Logger logger = LoggerFactory.getLogger(MenuBuilder.class);
    private EditorKit editorKit;
    private Set<ProtegeAction> actions;
    private Multimap<MenuActionPlugin, MenuActionPlugin> parentChildMap;
    private Map<String, ButtonGroup> group2ButtonGroupMap;

    public MenuBuilder(EditorKit editorKit) {
        this.editorKit = editorKit;
        this.parentChildMap = HashMultimap.create();
        this.group2ButtonGroupMap = new HashMap<String, ButtonGroup>();
        this.actions = new HashSet<ProtegeAction>();
    }

    public JMenuBar buildMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.parentChildMap.clear();
        Map<String, MenuActionPlugin> idPluginMap = this.getPlugins();
        for (MenuActionPlugin plugin : idPluginMap.values()) {
            MenuActionPlugin parent = idPluginMap.get(plugin.getParentId());
            this.getChildren(parent).add(plugin);
        }
        List<MenuActionPlugin> topLevelMenus = MenuBuilder.getSortedList(this.getChildren(null));
        for (MenuActionPlugin plugin : topLevelMenus) {
            this.addMenu(plugin, menuBar);
        }
        return menuBar;
    }

    private void addMenu(MenuActionPlugin plugin, JComponent menuContainer) {
        List<MenuActionPlugin> children = MenuBuilder.getSortedList(this.getChildren(plugin));
        if (!children.isEmpty()) {
            this.buildCompositeMenu(plugin, menuContainer, children);
        } else if (plugin.isDynamic()) {
            this.buildDynamicMenu(plugin, menuContainer);
        } else if (this.hasParentMenu(plugin)) {
            this.buildInnerMenu(plugin, menuContainer);
        } else {
            this.buildTopLevelMenu(plugin, menuContainer);
        }
    }

    private void buildCompositeMenu(MenuActionPlugin plugin, JComponent menuContainer, List<MenuActionPlugin> children) {
        JMenu menu = new JMenu(plugin.getName());
        menuContainer.add(menu);
        MenuActionPlugin lastPlugin = null;
        for (MenuActionPlugin childPlugin : children) {
            if (lastPlugin != null && !lastPlugin.getGroup().equals(childPlugin.getGroup())) {
                menu.addSeparator();
            }
            this.addMenu(childPlugin, menu);
            lastPlugin = childPlugin;
        }
    }

    private void buildDynamicMenu(MenuActionPlugin plugin, JComponent menuContainer) {
        JMenu menu = new JMenu(plugin.getName());
        menuContainer.add(menu);
        try {
            ProtegeDynamicAction action = (ProtegeDynamicAction)plugin.newInstance();
            this.invokeDynamicMenuMethods(action, menu);
            menu.addMenuListener(this.getDynamicMenuListener(menu, action));
            this.actions.add(action);
        }
        catch (Throwable e) {
            this.logger.error("An error occurred whilst building a dynamic menu.  Plugin name: {}", (Object)plugin.getName(), (Object)e);
        }
    }

    private void buildInnerMenu(MenuActionPlugin plugin, JComponent menuContainer) {
        try {
            ProtegeAction action = (ProtegeAction)plugin.newInstance();
            JMenuItem menuItem = this.createMenuItem(plugin, action);
            KeyStroke ks = plugin.getAccelerator();
            ks = this.fixAcceleratorForMacOSX(ks);
            menuItem.setAccelerator(ks);
            menuContainer.add(menuItem);
            this.invokeInnerMenuMethods(action, menuItem, menuContainer);
            this.actions.add(action);
        }
        catch (Exception e) {
            this.logger.warn("Error building menu: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (NoClassDefFoundError noClass) {
            this.logger.error("Error loading menu plugin {} ({})", (Object)plugin.getId(), (Object)plugin.getName());
        }
    }

    private void buildTopLevelMenu(MenuActionPlugin plugin, JComponent menuContainer) {
        JMenu menu = new JMenu(plugin.getName());
        menuContainer.add(menu);
    }

    private JMenuItem createMenuItem(MenuActionPlugin plugin, ProtegeAction action) {
        if (plugin.isCheckBox()) {
            return new JCheckBoxMenuItem(action);
        }
        if (plugin.isRadioButton()) {
            JRadioButtonMenuItem radioButtonMenuItem = new JRadioButtonMenuItem(action);
            ButtonGroup group = this.getButtonGroup(plugin);
            if (group != null) {
                group.add(radioButtonMenuItem);
            }
            return radioButtonMenuItem;
        }
        return new JMenuItem(action);
    }

    private ButtonGroup getButtonGroup(MenuActionPlugin plugin) {
        String group = plugin.getGroup();
        if (group == null) {
            return null;
        }
        ButtonGroup buttonGroup = this.group2ButtonGroupMap.get(group);
        if (buttonGroup == null) {
            buttonGroup = new ButtonGroup();
            this.group2ButtonGroupMap.put(group, buttonGroup);
        }
        return buttonGroup;
    }

    private KeyStroke fixAcceleratorForMacOSX(KeyStroke ks) {
        if (ks != null && ks.getKeyCode() == 127 && OSUtils.isOSX()) {
            ks = KeyStroke.getKeyStroke(8, ks.getModifiers());
        }
        return ks;
    }

    private MenuListener getDynamicMenuListener(final JMenu menu, final ProtegeDynamicAction action) {
        return new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                menu.removeAll();
                action.rebuildChildMenuItems(menu);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        };
    }

    private void invokeDynamicMenuMethods(ProtegeDynamicAction action, JMenu menu) {
        try {
            Method m = action.getClass().getMethod("setMenu", JMenu.class);
            m.invoke((Object)action, menu);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private void invokeInnerMenuMethods(ProtegeAction action, JMenuItem menuItem, JComponent menuContainer) {
        Method m2;
        try {
            m2 = action.getClass().getMethod("setMenuItem", JMenuItem.class);
            m2.invoke((Object)action, menuItem);
        }
        catch (Throwable m2) {
            // empty catch block
        }
        try {
            m2 = action.getClass().getMethod("setMenuParent", JComponent.class);
            m2.invoke((Object)action, menuContainer);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Map<String, MenuActionPlugin> getPlugins() {
        HashMap<String, MenuActionPlugin> result = new HashMap<String, MenuActionPlugin>();
        MenuActionPluginLoader pluginLoader = new MenuActionPluginLoader(this.editorKit);
        for (MenuActionPlugin plugin : pluginLoader.getPlugins()) {
            result.put(plugin.getId(), plugin);
            this.logger.debug("Added MenuActionPlugin: {}", (Object)plugin);
        }
        return result;
    }

    private Collection<MenuActionPlugin> getChildren(MenuActionPlugin plugin) {
        return this.parentChildMap.get((Object)plugin);
    }

    private static List<MenuActionPlugin> getSortedList(Collection<MenuActionPlugin> plugins) {
        ArrayList<MenuActionPlugin> list = new ArrayList<MenuActionPlugin>(plugins);
        Collections.sort(list, new MenuActionPluginComparator());
        return list;
    }

    private boolean hasParentMenu(MenuActionPlugin plugin) {
        return plugin.getParentId().length() > 0;
    }

    public Set<ProtegeAction> getActions() {
        return this.actions;
    }

    private static class MenuActionPluginComparator
    implements Comparator<MenuActionPlugin> {
        private MenuActionPluginComparator() {
        }

        @Override
        public int compare(MenuActionPlugin o1, MenuActionPlugin o2) {
            int result = o1.getGroup().compareTo(o2.getGroup());
            if (result == 0) {
                result = o1.getGroupIndex().compareTo(o2.getGroupIndex());
            }
            return result;
        }
    }
}

