/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.toolbar;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JToolBar;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.core.ui.action.ToolBarActionComparator;
import org.protege.editor.core.ui.action.ToolBarActionPluginJPFImpl;
import org.protege.editor.core.ui.toolbar.MainToolBarActionPluginLoader;
import org.slf4j.LoggerFactory;

public class MainToolBarBuilder {
    private EditorKit editorKit;

    public MainToolBarBuilder(EditorKit editorKit) {
        this.editorKit = editorKit;
    }

    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        MainToolBarActionPluginLoader editorKitSpecificLoader = new MainToolBarActionPluginLoader(this.editorKit);
        ArrayList list = new ArrayList();
        list.addAll(editorKitSpecificLoader.getPlugins());
        MainToolBarActionPluginLoader generalLoader = new MainToolBarActionPluginLoader(null);
        list.addAll(generalLoader.getPlugins());
        Collections.sort(list, new ToolBarActionComparator());
        ToolBarActionPluginJPFImpl lastPlugin = null;
        for (ToolBarActionPluginJPFImpl plugin : list) {
            try {
                if (lastPlugin != null && !lastPlugin.getGroup().equals(plugin.getGroup())) {
                    toolBar.addSeparator();
                }
                ProtegeAction action = plugin.newInstance();
                toolBar.add(action);
                action.initialise();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).warn("Couldn't load main toolbar item", (Throwable)e);
            }
        }
        return toolBar;
    }
}

