/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class AugmentedJTextField
extends JTextField {
    public static final Color DEFAULT_GHOST_TEXT_COLOR = Color.LIGHT_GRAY;
    private String errorMessage = "";
    private int errorLocation = -1;
    private String ghostText = "";

    public AugmentedJTextField(String ghostText) {
        this.ghostText = ghostText;
    }

    public AugmentedJTextField(String text, String ghostText) {
        super(text);
        this.ghostText = ghostText;
    }

    public AugmentedJTextField(int columns, String ghostText) {
        super(columns);
        this.ghostText = ghostText;
    }

    public AugmentedJTextField(String text, int columns, String ghostText) {
        super(text, columns);
        this.ghostText = ghostText;
    }

    public AugmentedJTextField(Document doc, String text, int columns, String ghostText) {
        super(doc, text, columns);
        this.ghostText = ghostText;
    }

    public int getErrorLocation() {
        return this.errorLocation;
    }

    public void setErrorLocation(int errorLocation) {
        if (this.errorLocation != errorLocation) {
            this.errorLocation = errorLocation;
            this.repaint();
        }
    }

    public void clearErrorLocation() {
        if (this.errorLocation != -1) {
            this.errorLocation = -1;
            this.repaint();
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getGhostText() {
        return this.ghostText;
    }

    public void setGhostText(String ghostText) {
        if (!this.ghostText.equals(ghostText)) {
            this.ghostText = ghostText;
            this.repaint();
        }
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.repaint();
    }

    public void clearErrorMessage() {
        if (!this.errorMessage.isEmpty()) {
            this.errorMessage = "";
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        try {
            if (this.errorLocation != -1) {
                g.setColor(Color.PINK);
                Rectangle rectStart = this.modelToView(this.errorLocation);
                Rectangle rectEnd = this.modelToView(this.errorLocation + 1);
                g.fillRect(rectStart.x, rectStart.y, rectEnd.x - rectStart.x, rectStart.height);
            }
            if (this.getText().isEmpty()) {
                g.setColor(DEFAULT_GHOST_TEXT_COLOR);
                int baseLine = this.getBaseline(this.getWidth(), this.getHeight());
                Insets insets = this.getInsets();
                g.drawString(this.ghostText, insets.left, baseLine);
            }
            if (!this.errorMessage.isEmpty()) {
                int baseLine = this.getBaseline(this.getWidth(), this.getHeight());
                Rectangle rect = this.modelToView(this.getText().length());
                g.setColor(Color.PINK);
                g.drawString(this.errorMessage, rect.x + 20, baseLine);
            }
        }
        catch (BadLocationException e) {
            System.err.println(e.getMessage());
        }
        g.setColor(oldColor);
    }
}

