/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.protege.editor.core.ui.util.CheckTableModel;
import org.protege.editor.core.ui.util.TableUtils;

public class CheckTable<O>
extends JTable {
    private static final long serialVersionUID = -4641194513464703616L;
    public static Boolean defaultSelected = false;
    private JCheckBox checkAllCheckbox;
    private TableCellRenderer renderer;
    private List<ListSelectionListener> checkSelListeners = new ArrayList<ListSelectionListener>();
    private DefaultTableCellRenderer headerRenderer = new DefaultTableCellRenderer(){
        private static final long serialVersionUID = 5322154037663255057L;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (col == 0) {
                return CheckTable.this.checkAllCheckbox;
            }
            return super.getTableCellRendererComponent(jTable, value, isSelected, hasFocus, row, col);
        }
    };
    private MouseAdapter checkAllMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel;
            int viewColumn;
            JTableHeader header = (JTableHeader)e.getSource();
            JTable tableView = header.getTable();
            int column = tableView.convertColumnIndexToModel(viewColumn = (columnModel = tableView.getColumnModel()).getColumnIndexAtX(e.getX()));
            if (column == 0 && viewColumn == column && e.getClickCount() == 1) {
                CheckTable.this.checkAllCheckbox.doClick();
            }
            header.repaint();
        }
    };
    private ChangeListener checkAllActionListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent event) {
            for (int i = 0; i < ((DefaultTableModel)CheckTable.this.getModel()).getRowCount(); ++i) {
                ((DefaultTableModel)CheckTable.this.getModel()).setValueAt(CheckTable.this.checkAllCheckbox.isSelected(), i, 0);
            }
            CheckTable.this.notifyCheckSelectionChanged();
        }
    };
    private CellEditorListener checkEditorListener = new CellEditorListener(){

        @Override
        public void editingStopped(ChangeEvent event) {
            CheckTable.this.notifyCheckSelectionChanged();
        }

        @Override
        public void editingCanceled(ChangeEvent event) {
        }
    };
    private boolean requiresPack = true;

    public CheckTable(String name) {
        super(new CheckTableModel(name));
        this.setShowGrid(true);
        this.setIntercellSpacing(new Dimension(0, 3));
        JTableHeader header = this.getTableHeader();
        header.setReorderingAllowed(false);
        header.addMouseListener(this.checkAllMouseListener);
        this.checkAllCheckbox = new JCheckBox();
        this.checkAllCheckbox.setSelected(defaultSelected);
        this.checkAllCheckbox.addChangeListener(this.checkAllActionListener);
        this.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "checkSelection");
        this.getActionMap().put("checkSelection", new AbstractAction(){
            private static final long serialVersionUID = 6324092579357208331L;

            @Override
            public void actionPerformed(ActionEvent event) {
                CheckTable.this.checkSelection();
            }
        });
        this.getDefaultEditor(Boolean.class).addCellEditorListener(this.checkEditorListener);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int i, int i1) {
        Component c = super.prepareRenderer(tableCellRenderer, i, i1);
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).setVerticalAlignment(1);
        }
        return c;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int i, int i1) {
        Component c = super.prepareEditor(tableCellEditor, i, i1);
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).setVerticalAlignment(1);
        }
        return c;
    }

    @Override
    public CheckTableModel<O> getModel() {
        return (CheckTableModel)super.getModel();
    }

    public void checkAll(boolean b) {
        this.checkAllCheckbox.setSelected(b);
        this.revalidate();
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        this.requiresPack = true;
    }

    @Override
    public void tableChanged(TableModelEvent event) {
        super.tableChanged(event);
        if (event.getType() == 1) {
            this.requiresPack = true;
        }
    }

    @Override
    public void doLayout() {
        if (this.requiresPack) {
            this.requiresPack = false;
            this.pack();
        }
        super.doLayout();
    }

    private void pack() {
        TableColumn checkCol = this.getColumnModel().getColumn(0);
        if (this.headerRenderer != null) {
            checkCol.setHeaderRenderer(this.headerRenderer);
        }
        TableUtils.pack(this, true, true, 2);
        if (checkCol != null) {
            checkCol.setMaxWidth(checkCol.getPreferredWidth());
            checkCol.setResizable(false);
        }
    }

    public void setDefaultRenderer(TableCellRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> aClass) {
        if (this.renderer == null || aClass.equals(Boolean.class)) {
            return super.getDefaultRenderer(aClass);
        }
        return this.renderer;
    }

    public List<O> getFilteredValues() {
        return ((CheckTableModel)this.getModel()).getFilteredValues();
    }

    private void checkSelection() {
        boolean value = false;
        for (int row : this.getSelectedRows()) {
            if (!this.getValueAt(row, 0).equals(Boolean.FALSE)) continue;
            value = true;
        }
        for (int row : this.getSelectedRows()) {
            this.setValueAt(value, row, 0);
        }
        this.notifyCheckSelectionChanged();
    }

    public void addCheckSelectionListener(ListSelectionListener l) {
        this.checkSelListeners.add(l);
    }

    public void removeCheckSelectionListener(ListSelectionListener l) {
        this.checkSelListeners.remove(l);
    }

    private void notifyCheckSelectionChanged() {
        int min = -1;
        int max = -1;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getValueAt(i, 0).equals(Boolean.TRUE)) continue;
            if (min == -1) {
                min = i;
            }
            max = i;
        }
        for (ListSelectionListener l : this.checkSelListeners) {
            l.valueChanged(new ListSelectionEvent(this, min, max, false));
        }
    }

    public List<O> getAllValues() {
        return ((CheckTableModel)this.getModel()).getAllValues();
    }

    public static void main(String[] args) {
        CheckTable table = new CheckTable("things");
        TableModel model = table.getModel();
        ArrayList<String> data = new ArrayList<String>();
        data.add("one");
        data.add("two");
        data.add("three");
        data.add("long long long line of text that should still fit in the box");
        data.add("<html>some hmtl with <br><br>linebreaks and <p>paragraphs etc</p></html>");
        ((CheckTableModel)model).setData(data, false);
        ((DefaultTableModel)model).addColumn("more", new String[]{"a", "nother column full of stuff", "fffrrr"});
        JScrollPane scroller = new JScrollPane(table);
        JPanel holder = new JPanel(new BorderLayout());
        holder.add((Component)scroller, "Center");
        holder.add((Component)new JCheckBox("check"), "North");
        JOptionPane optionPane = new JOptionPane(holder, -1, 2);
        JDialog dlg = CheckTable.createDialog(null, "test CheckTable", optionPane);
        dlg.setVisible(true);
        System.exit(0);
    }

    private static JDialog createDialog(JComponent parent, String title, JOptionPane optionPane) {
        JDialog dlg = optionPane.createDialog(parent, title);
        dlg.setLocationRelativeTo(parent);
        dlg.setResizable(true);
        dlg.pack();
        return dlg;
    }
}

