/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.UIUtil;

public class FilePathPanel
extends JPanel {
    private static final long serialVersionUID = 8238154511092480343L;
    private String fileChooserText;
    private Set<String> extensions;
    private List<ChangeListener> listeners;
    private JTextField textField;
    private boolean selectFolders = false;
    private Action browseAction;
    public static final int OPEN_DIALOG_MODE = 0;
    public static final int SAVE_DIALOG_MODE = 1;
    private int dialogMode = 0;

    public FilePathPanel(String fileChooserText, Set<String> extensions) {
        this.fileChooserText = fileChooserText;
        this.extensions = new HashSet<String>(extensions);
        this.listeners = new ArrayList<ChangeListener>();
        this.setLayout(new BorderLayout(3, 3));
        this.textField = ComponentFactory.createTextField();
        this.add((Component)this.textField, "North");
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FilePathPanel.this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FilePathPanel.this.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.browseAction = new AbstractAction("Browse..."){
            private static final long serialVersionUID = -392303565634614444L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilePathPanel.this.selectFolders) {
                    FilePathPanel.this.browseForFolder();
                } else {
                    FilePathPanel.this.browseForFile();
                }
            }
        };
        this.add((Component)new JButton(this.browseAction), "East");
    }

    public int getDialogMode() {
        return this.dialogMode;
    }

    public void setDialogMode(int dialogMode) {
        this.dialogMode = dialogMode;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.browseAction.setEnabled(enabled);
    }

    public void setPath(String path) {
        this.textField.setText(path);
    }

    public void setSelectsFolders(boolean selectFolders) {
        this.selectFolders = selectFolders;
    }

    public void browseForFile() {
        File file;
        Window f = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        File file2 = file = this.dialogMode == 0 ? UIUtil.openFile(f, this.fileChooserText, "OWL File", this.extensions) : UIUtil.saveFile(new JFrame(), this.fileChooserText, "OWL File", this.extensions);
        if (file != null) {
            this.textField.setText(file.toString());
        }
    }

    public void browseForFolder() {
        File f = UIUtil.chooseFolder(this, "Select a folder");
        if (f != null) {
            this.textField.setText(f.toString());
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    protected void fireChange() {
        for (ChangeListener listener : new ArrayList<ChangeListener>(this.listeners)) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    public File getFile() {
        return new File(this.textField.getText());
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }
}

