/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.core.ui.util.VerifyingOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JOptionPaneEx {
    private static final Logger logger = LoggerFactory.getLogger(JOptionPaneEx.class);

    public static int showConfirmDialog(Component parent, String title, JComponent content, int messageType, int optionType, final JComponent defaultFocusedComponent) {
        JOptionPane optionPane = new JOptionPane((Object)content, messageType, optionType){

            @Override
            public void selectInitialValue() {
                if (defaultFocusedComponent != null) {
                    defaultFocusedComponent.requestFocusInWindow();
                }
            }
        };
        JDialog dlg = JOptionPaneEx.createDialog(parent, title, optionPane, defaultFocusedComponent);
        dlg.setVisible(true);
        return JOptionPaneEx.getReturnValueAsInteger(optionPane);
    }

    public static int showConfirmDialog(Component parent, String title, JComponent content, int messageType, int optionType, final JComponent defaultFocusedComponent, Object[] options, Object defaultOption) {
        JOptionPane optionPane = new JOptionPane(content, messageType, optionType, null, options, defaultOption){

            @Override
            public void selectInitialValue() {
                if (defaultFocusedComponent != null) {
                    defaultFocusedComponent.requestFocusInWindow();
                }
            }
        };
        JDialog dlg = JOptionPaneEx.createDialog(parent, title, optionPane, defaultFocusedComponent);
        dlg.setVisible(true);
        return JOptionPaneEx.getReturnValueAsInteger(optionPane);
    }

    public static int showValidatingConfirmDialog(Component parent, String title, JComponent component, int messageType, int optionType, final JComponent defaultFocusedComponent) {
        if (component instanceof VerifiedInputEditor) {
            final VerifyingOptionPane optionPane = new VerifyingOptionPane(component, messageType, optionType){
                private static final long serialVersionUID = 7128847118051849761L;

                @Override
                public void selectInitialValue() {
                    if (defaultFocusedComponent != null) {
                        defaultFocusedComponent.requestFocusInWindow();
                    }
                }
            };
            InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                @Override
                public void verifiedStatusChanged(boolean verified) {
                    optionPane.setOKEnabled(verified);
                }
            };
            ((VerifiedInputEditor)((Object)component)).addStatusChangedListener(verificationListener);
            JDialog dlg = JOptionPaneEx.createDialog(parent, title, optionPane, defaultFocusedComponent);
            dlg.setModal(true);
            dlg.setVisible(true);
            return JOptionPaneEx.getReturnValueAsInteger(optionPane);
        }
        logger.warn("Component should implement VerifiedInputEditor for validating dialog to work. Using normal dialog with no validating");
        return JOptionPaneEx.showConfirmDialog(parent, title, component, messageType, optionType, null);
    }

    private static JDialog createDialog(Component parent, String title, JOptionPane optionPane, JComponent defaultFocusedComponent) {
        JDialog dlg = optionPane.createDialog(parent, title);
        dlg.setLocationRelativeTo(parent);
        dlg.setResizable(true);
        dlg.pack();
        return dlg;
    }

    private static int getReturnValueAsInteger(JOptionPane optionPane) {
        Object value = optionPane.getValue();
        if (value == null) {
            return -1;
        }
        Object[] options = optionPane.getOptions();
        if (options == null) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return -1;
        }
        for (int i = 0; i < options.length; ++i) {
            Object valueAtIndex = options[i];
            if (!value.equals(valueAtIndex)) continue;
            return i;
        }
        return -1;
    }
}

