/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.coode.mdock.ComponentNode;
import org.coode.mdock.Node;
import org.coode.mdock.NodeComponent;
import org.coode.mdock.NodePanel;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.core.ui.action.ToolBarActionComparator;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.Icons;
import org.protege.editor.core.ui.view.ViewAction;
import org.protege.editor.core.ui.view.ViewActionPlugin;
import org.protege.editor.core.ui.view.ViewBarComponent;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.view.ViewContainer;
import org.protege.editor.core.ui.view.ViewToolBarActionPluginLoader;
import org.protege.editor.core.ui.workspace.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class View
extends JComponent
implements NodeComponent,
Disposable {
    private static final long serialVersionUID = 2974633149164991481L;
    private final Logger logger = LoggerFactory.getLogger(View.class);
    public static final String DETACHED_WINDOWS_FLOAT = "DETACHED_WINDOWS_FLOAT";
    private static final String SPLIT_VERTICALLY_ICON_NAME = "view.splitvertically.gif";
    private static final String SPLIT_HORIZONTALLY_ICON_NAME = "view.horizontalsplit.gif";
    private static final String FLOAT_ICON_NAME = "view.float.gif";
    private static final String CLOSE_ICON_NAME = "view.close.gif";
    private ViewComponentPlugin plugin;
    private Workspace workspace;
    private ViewBarComponent viewBarComponent;
    private JPanel viewComponentHolder;
    private ViewComponent viewComponent;
    private ComponentNode componentNode;
    private boolean closable = false;
    private boolean floatable = false;
    private boolean splitable = true;
    private boolean pinned = false;
    private boolean syncronizing = true;
    private boolean persist = true;
    private boolean initialisedContent = false;
    private Set<ViewActionPlugin> additionalViewActionPlugins;
    private Set<ViewAction> addedViewActions;

    public View(ViewComponentPlugin plugin, Workspace workspace) {
        this.plugin = plugin;
        this.workspace = workspace;
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (!View.this.initialisedContent && View.this.isShowing()) {
                    View.this.createUI();
                    View.this.initialisedContent = true;
                    View.this.removeHierarchyListener(this);
                }
            }
        });
        this.additionalViewActionPlugins = new HashSet<ViewActionPlugin>();
        this.addedViewActions = new HashSet<ViewAction>();
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.viewComponent == null) {
            return false;
        }
        return this.viewComponent.requestFocusInWindow();
    }

    public void setShowViewBar(boolean b) {
        this.viewBarComponent.getViewBar().setVisible(b);
    }

    public void setShowViewBanner(boolean b) {
        this.viewBarComponent.getViewBar().getViewBanner().setVisible(b);
    }

    public ComponentNode getComponentNode() {
        return this.componentNode;
    }

    public String getId() {
        return this.plugin.getId();
    }

    public void setHeaderText(String text) {
        this.viewBarComponent.getViewBar().getViewBanner().setText(text);
    }

    public String getViewName() {
        return this.plugin.getLabel();
    }

    public void createUI() {
        this.initialisedContent = true;
        this.logger.debug("Creating the UI for the '{}' view", (Object)this.getViewName());
        this.setLayout(new BorderLayout(0, 0));
        this.viewComponentHolder = new JPanel(new BorderLayout());
        this.viewBarComponent = new ViewBarComponent(this.getViewName(), this.plugin.getBackgroundColor(), this.viewComponentHolder);
        this.add(this.viewBarComponent);
        this.addViewManipulationActions();
        this.createContent();
        this.createViewToolBar();
        this.viewBarComponent.getViewBar().getViewBanner().setPinned(this.pinned);
    }

    public void setHeaderBackgroundColor(Color color) {
        this.viewBarComponent.getViewBar().getViewBanner().setBannerColor(color);
    }

    public void hideViewBar() {
        this.viewBarComponent.getViewBar().setVisible(false);
    }

    private void createViewToolBar() {
        ViewToolBarActionPluginLoader loader = new ViewToolBarActionPluginLoader(this.workspace.getEditorKit(), this);
        ArrayList<ViewActionPlugin> plugins = new ArrayList<ViewActionPlugin>(loader.getPlugins());
        plugins.addAll(this.additionalViewActionPlugins);
        Collections.sort(plugins, new ToolBarActionComparator());
        String lastGroup = null;
        for (ViewActionPlugin plugin : plugins) {
            try {
                ViewAction action = (ViewAction)plugin.newInstance();
                if (lastGroup != null && !plugin.getGroup().equals(lastGroup)) {
                    this.viewBarComponent.getViewBar().addSeparator();
                }
                if (action.getValue("ShortDescription") == null) {
                    action.putValue("ShortDescription", action.getValue("Name"));
                }
                this.viewBarComponent.getViewBar().addAction(action);
                KeyStroke acceleratorKeyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                if (acceleratorKeyStroke != null) {
                    String key = "Accelerator" + System.currentTimeMillis();
                    this.getInputMap(1).put(acceleratorKeyStroke, key);
                    this.getActionMap().put(key, action);
                    action.putValue("ShortDescription", action.getValue("ShortDescription") + " (" + KeyEvent.getKeyModifiersText(acceleratorKeyStroke.getModifiers()) + " " + KeyEvent.getKeyText(acceleratorKeyStroke.getKeyCode()) + ")");
                }
                lastGroup = plugin.getGroup();
                action.setView(this);
                action.setEditorKit(this.workspace.getEditorKit());
                action.initialise();
                this.addedViewActions.add(action);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void addAction(final ProtegeAction action, final String group, final String groupIndex) {
        ViewActionPlugin plugin = new ViewActionPlugin(){

            @Override
            public String getId() {
                return null;
            }

            @Override
            public String getName() {
                return (String)action.getValue("Name");
            }

            @Override
            public String getToolTipText() {
                return (String)action.getValue("ShortDescription");
            }

            @Override
            public Icon getIcon() {
                return (Icon)action.getValue("SmallIcon");
            }

            @Override
            public EditorKit getEditorKit() {
                return View.this.workspace.getEditorKit();
            }

            @Override
            public String getDocumentation() {
                return null;
            }

            @Override
            public ProtegeAction newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
                return action;
            }

            @Override
            public View getView() {
                return View.this;
            }

            @Override
            public String getGroup() {
                return group;
            }

            @Override
            public String getGroupIndex() {
                return groupIndex;
            }
        };
        this.additionalViewActionPlugins.add(plugin);
    }

    private void addViewManipulationActions() {
        this.viewBarComponent.getViewBar().getViewBanner().addAction(new AbstractAction("Split vertically", Icons.getIcon(SPLIT_VERTICALLY_ICON_NAME)){
            private static final long serialVersionUID = 8586844910392022364L;

            @Override
            public void actionPerformed(ActionEvent e) {
                View.this.splitVertically();
            }
        });
        this.viewBarComponent.getViewBar().getViewBanner().addAction(new AbstractAction("Split horizontally", Icons.getIcon(SPLIT_HORIZONTALLY_ICON_NAME)){
            private static final long serialVersionUID = 650343120768163122L;

            @Override
            public void actionPerformed(ActionEvent e) {
                View.this.splitHorizontally();
            }
        });
        this.viewBarComponent.getViewBar().getViewBanner().addAction(new AbstractAction("Float", Icons.getIcon(FLOAT_ICON_NAME)){
            private static final long serialVersionUID = 680867093090160266L;

            @Override
            public void actionPerformed(ActionEvent e) {
                View.this.copyAndFloatView();
            }
        });
        this.viewBarComponent.getViewBar().getViewBanner().addAction(new AbstractAction("Close", Icons.getIcon(CLOSE_ICON_NAME)){
            private static final long serialVersionUID = 7953501606173990976L;

            @Override
            public void actionPerformed(ActionEvent e) {
                View.this.closeView();
            }
        });
    }

    private NodePanel getNodePanel() {
        return (NodePanel)SwingUtilities.getAncestorOfClass(NodePanel.class, this);
    }

    public void splitVerticallyWith(ViewComponentPlugin plugin) {
        if (this.getNodePanel() != null) {
            ComponentNode newNode = new ComponentNode();
            newNode.add((JComponent)this.createView(plugin), plugin.getLabel());
            this.componentNode.getParent().insertNodeAfter((Node)newNode, (Node)this.componentNode, 1);
            this.getNodePanel().rebuild();
        } else if (this.getParent() instanceof ViewContainer) {
            ((ViewContainer)this.getParent()).splitVertically(this.createView(plugin));
        }
    }

    private View createView(ViewComponentPlugin plugin) {
        View sv = new View(plugin, this.workspace);
        sv.pinned = true;
        return sv;
    }

    public void splitVertically() {
        this.splitVerticallyWith(this.plugin);
    }

    public void splitHorizontally() {
        this.splitHorizontallyWith(this.plugin);
    }

    public void splitHorizontallyWith(ViewComponentPlugin plugin) {
        if (this.getNodePanel() != null) {
            ComponentNode newNode = new ComponentNode();
            newNode.add((JComponent)this.createView(plugin), plugin.getLabel());
            this.componentNode.getParent().insertNodeAfter((Node)newNode, (Node)this.componentNode, 0);
            this.getNodePanel().rebuild();
        } else if (this.getParent() instanceof ViewContainer) {
            ((ViewContainer)this.getParent()).splitHorizontally(this.createView(plugin));
        }
    }

    private void createContent() {
        try {
            this.viewComponent = (ViewComponent)this.plugin.newInstance();
            this.viewComponentHolder.add(this.viewComponent);
            this.viewComponent.setView(this);
            this.viewComponent.initialise();
        }
        catch (Exception e) {
            this.logger.error("An error occurred whilst creating the view content for the '{}' view: {}", (Object)this.plugin.getLabel(), (Object)e);
            this.viewComponentHolder.add(ComponentFactory.createExceptionComponent("An error occurred whilst creating the view", e, null));
        }
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
        if (this.viewBarComponent != null) {
            this.viewBarComponent.getViewBar().getViewBanner().setPinned(pinned);
        }
    }

    public boolean isClosable() {
        return this.closable;
    }

    public boolean isFloatable() {
        return this.floatable;
    }

    public boolean isSplitable() {
        return this.splitable;
    }

    public boolean isSyncronizing() {
        return this.syncronizing;
    }

    public boolean persist() {
        return this.persist;
    }

    public void setSyncronizing(boolean syncronizing) {
        this.syncronizing = syncronizing;
    }

    public ViewComponent getViewComponent() {
        return this.viewComponent;
    }

    public void closeView() {
        NodePanel nodePanel = (NodePanel)SwingUtilities.getAncestorOfClass(NodePanel.class, this);
        if (nodePanel != null) {
            this.getParent().remove(this);
            this.dispose();
            nodePanel.rebuild();
            nodePanel.repaint();
        } else if (this.getParent() instanceof ViewContainer) {
            ((ViewContainer)this.getParent()).closeView(this);
            this.dispose();
        }
    }

    private void copyAndFloatView() {
        Dimension size = this.getSize();
        Point loc = this.getLocation();
        SwingUtilities.convertPointToScreen(loc, this);
        final View view = this.createView(this.plugin);
        Preferences appPrefs = PreferencesManager.getInstance().getApplicationPreferences("org.protege.editor.core.application");
        JDialog dlg = appPrefs.getBoolean(DETACHED_WINDOWS_FLOAT, true) ? new JDialog(ProtegeManager.getInstance().getFrame(this.workspace)) : new JDialog();
        view.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.viewBarComponent.setEnabled(false);
        JPanel holder = new JPanel(new BorderLayout(3, 3));
        holder.add(view);
        final JCheckBox cb = new JCheckBox();
        JPanel checkBoxHolder = new JPanel(new BorderLayout());
        checkBoxHolder.add((Component)cb, "South");
        checkBoxHolder.setBorder(BorderFactory.createEmptyBorder(1, 4, 4, 2));
        holder.add((Component)checkBoxHolder, "South");
        cb.setAction(new AbstractAction("Synchronising"){
            private static final long serialVersionUID = -4131922452059512538L;

            @Override
            public void actionPerformed(ActionEvent e) {
                view.setSyncronizing(cb.isSelected());
                view.setPinned(!cb.isSelected());
            }
        });
        dlg.setContentPane(holder);
        dlg.setSize(size);
        dlg.setLocation(loc);
        dlg.setDefaultCloseOperation(2);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    view.dispose();
                    view.getViewComponent().dispose();
                }
                catch (Exception e1) {
                    View.this.logger.warn("BAD VIEW: (" + view.getViewComponent().getClass().getSimpleName() + ") - exception on dispose: " + e1.getMessage());
                }
            }
        });
        dlg.validate();
        dlg.setVisible(true);
        view.syncronizing = false;
    }

    @Override
    public void dispose() {
        if (this.initialisedContent) {
            for (ViewAction action : this.addedViewActions) {
                try {
                    action.dispose();
                }
                catch (Exception e) {
                    this.logger.warn("BAD ViewAction: (" + action.getClass().getSimpleName() + ") Exception on dispose: " + e.getMessage());
                }
            }
            this.addedViewActions.clear();
            if (this.viewComponent != null) {
                try {
                    this.viewComponent.dispose();
                }
                catch (Exception e) {
                    this.logger.warn("BAD ViewComponent: (" + this.viewComponent.getClass().getSimpleName() + ") Exception on dispose: " + e.getMessage());
                }
            }
        }
    }

    public void addedToNode(ComponentNode node) {
        this.componentNode = node;
    }
}

