/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.view;

import javax.swing.JComponent;
import org.protege.editor.core.plugin.ProtegePluginInstance;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.core.ui.util.SelectionProvider;
import org.protege.editor.core.ui.view.DisposableAction;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewActionAdapter;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.workspace.Workspace;

public abstract class ViewComponent
extends JComponent
implements ProtegePluginInstance {
    private static final long serialVersionUID = -3219436558092741068L;
    private Workspace workspace;
    private View view;

    public void setup(ViewComponentPlugin plugin) {
        this.workspace = plugin.getWorkspace();
    }

    public void setView(View view) {
        this.view = view;
    }

    public View getView() {
        return this.view;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    protected void setHeaderText(String text) {
        if (this.view != null) {
            this.view.setHeaderText(text);
        }
    }

    protected void addAction(ProtegeAction action, String group, String groupIndex) {
        if (this.view != null) {
            this.view.addAction(action, group, groupIndex);
        }
    }

    protected void addAction(DisposableAction action, String group, String groupIndex) {
        this.addAction(new ViewActionAdapter(action), group, groupIndex);
    }

    protected boolean isPinned() {
        if (this.view != null) {
            return this.view.isPinned();
        }
        return false;
    }

    protected boolean isSynchronizing() {
        if (this.view != null) {
            return this.view.isSyncronizing();
        }
        return false;
    }

    protected SelectionProvider getSelectionProvider() {
        return null;
    }
}

