/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.progress.BackgroundTask;
import org.protege.editor.core.update.PluginInfo;
import org.protege.editor.core.update.PluginInstaller;
import org.protege.editor.core.update.PluginPanel;
import org.protege.editor.core.update.PluginRegistryImpl;

public class PluginManager {
    private static final String LAST_RUN_PREFS_KEY = "last.run";
    private static final PluginManager instance = new PluginManager();
    public static final String AUTO_UPDATE_KEY = "CheckForUpdates";
    public static final String PLUGIN_REGISTRY_KEY = "plugin.registry-5.0.url";
    public static final String DEFAULT_REGISTRY = "https://raw.githubusercontent.com/protegeproject/autoupdate/master/update-info/5.0.0/plugins.repository";

    private PluginManager() {
    }

    public static synchronized PluginManager getInstance() {
        return instance;
    }

    private Preferences getPrefs() {
        PreferencesManager man = PreferencesManager.getInstance();
        return man.getApplicationPreferences(PluginManager.class);
    }

    public void setAutoUpdateEnabled(boolean b) {
        this.getPrefs().putBoolean(AUTO_UPDATE_KEY, b);
    }

    public boolean isAutoUpdateEnabled() {
        return this.getPrefs().getBoolean(AUTO_UPDATE_KEY, true);
    }

    public URL getPluginRegistryLocation() {
        String pluginRegistryLoc = this.getPrefs().getString(PLUGIN_REGISTRY_KEY, DEFAULT_REGISTRY);
        try {
            return new URL(pluginRegistryLoc);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPluginRegistryLocation(URL url) {
        String oldPluginRegistryLoc = this.getPrefs().getString(PLUGIN_REGISTRY_KEY, DEFAULT_REGISTRY);
        String newPluginRegistryLoc = url.toString();
        if (!newPluginRegistryLoc.equals(oldPluginRegistryLoc)) {
            this.getPrefs().putString(PLUGIN_REGISTRY_KEY, newPluginRegistryLoc);
        }
    }

    public Date getLastAutoUpdateDate() {
        long lastRun = this.getPrefs().getLong(LAST_RUN_PREFS_KEY, 0L);
        return new Date(lastRun);
    }

    public void runAutoUpdate() {
        this.runSearch(SearchType.UPDATES_ONLY);
    }

    public void runCheckForPlugins() {
        this.runSearch(SearchType.UPDATES_AND_INSTALLS);
    }

    private void runSearch(SearchType searchType) {
        BackgroundTask autoUpdateTask = ProtegeApplication.getBackgroundTaskManager().startTask("autoupdate");
        Runnable runnable = () -> {
            PluginRegistryImpl updatesProvider = new PluginRegistryImpl(this.getPluginRegistryLocation());
            try {
                updatesProvider.reload();
                this.getPrefs().putLong(LAST_RUN_PREFS_KEY, System.currentTimeMillis());
            }
            finally {
                ProtegeApplication.getBackgroundTaskManager().endTask(autoUpdateTask);
                ArrayListMultimap map = ArrayListMultimap.create();
                List<PluginInfo> availableUpdates = updatesProvider.getAvailableUpdates();
                map.putAll((Object)PluginRegistryImpl.PluginRegistryType.PLUGIN_UPDATE_REGISTRY.getLabel(), availableUpdates);
                map.putAll((Object)PluginRegistryImpl.PluginRegistryType.PLUGIN_DOWNLOAD_REGISTRY.getLabel(), updatesProvider.getAvailableInstalls());
                if (searchType == SearchType.UPDATES_ONLY && !availableUpdates.isEmpty()) {
                    this.showUpdatesDialog((ListMultimap<String, PluginInfo>)map);
                }
                if (searchType == SearchType.UPDATES_AND_INSTALLS) {
                    this.showUpdatesDialog((ListMultimap<String, PluginInfo>)map);
                }
            }
        };
        Thread t = new Thread(runnable, "Auto-Update");
        t.setPriority(1);
        t.start();
    }

    private void showUpdatesDialog(ListMultimap<String, PluginInfo> downloadsProviders) {
        SwingUtilities.invokeLater(() -> {
            List<PluginInfo> selUpdates = PluginPanel.showDialog(downloadsProviders, null);
            if (!selUpdates.isEmpty()) {
                PluginInstaller installer = new PluginInstaller(selUpdates);
                installer.run();
            }
        });
    }

    private static enum SearchType {
        UPDATES_ONLY,
        UPDATES_AND_INSTALLS;

    }
}

