/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.core.plugin.PluginUtilities;
import org.protege.editor.core.update.PluginDocumentParseException;
import org.protege.editor.core.update.PluginInfo;
import org.protege.editor.core.update.PluginRegistry;
import org.protege.editor.core.update.UpdateChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class PluginRegistryImpl
implements PluginRegistry {
    public static final Marker AUTO_UPDATE = MarkerFactory.getMarker((String)"Auto-Update");
    private static final Logger logger = LoggerFactory.getLogger(PluginRegistryImpl.class);
    public static final String UPDATE_URL = "Update-Url";
    private final URL root;
    private final List<PluginInfo> updates = new ArrayList<PluginInfo>();
    private final List<PluginInfo> installs = new ArrayList<PluginInfo>();

    public PluginRegistryImpl(URL root) {
        this.root = root;
    }

    @Override
    public void reload() {
        this.updates.clear();
        this.installs.clear();
        Calculator calculator = new Calculator(this.root);
        calculator.run();
        this.updates.addAll(calculator.getUpdates());
        this.installs.addAll(calculator.getInstalls());
    }

    @Override
    public List<PluginInfo> getAvailableUpdates() {
        return this.updates;
    }

    @Override
    public List<PluginInfo> getAvailableInstalls() {
        return this.installs;
    }

    private static void sortPlugins(List<PluginInfo> plugins) {
        Collections.sort(plugins, new Comparator<PluginInfo>(){

            @Override
            public int compare(PluginInfo o1, PluginInfo o2) {
                String l1 = o1.getLabel();
                String l2 = o2.getLabel();
                return l1.compareToIgnoreCase(l2);
            }
        });
    }

    private static String pad(int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append("    ");
        }
        return sb.toString();
    }

    private static class Calculator {
        private URL root;
        private BundleContext context = PluginUtilities.getInstance().getApplicationContext();
        private Map<String, Bundle> bundleByIds = new HashMap<String, Bundle>();
        private Set<String> selfUpdatingBundleIds = new HashSet<String>();
        private Set<URL> visitedURLs = new HashSet<URL>();
        private final List<PluginInfo> updates = new ArrayList<PluginInfo>();
        private final List<PluginInfo> installs = new ArrayList<PluginInfo>();

        public Calculator(URL root) {
            this.root = root;
        }

        public void run() {
            logger.info(LogBanner.start("Running Auto-update"));
            logger.info("");
            this.mapIdsToBundles();
            this.checkBundles();
            this.checkForDownloads(this.root);
            PluginRegistryImpl.sortPlugins(this.updates);
            PluginRegistryImpl.sortPlugins(this.installs);
            logger.info(LogBanner.end());
        }

        private void mapIdsToBundles() {
            if (this.context == null) {
                return;
            }
            for (Bundle bundle : this.context.getBundles()) {
                this.bundleByIds.put(bundle.getSymbolicName(), bundle);
            }
        }

        public List<PluginInfo> getUpdates() {
            return new ArrayList<PluginInfo>(this.updates);
        }

        public List<PluginInfo> getInstalls() {
            return new ArrayList<PluginInfo>(this.installs);
        }

        private void checkBundles() {
            if (this.context == null) {
                return;
            }
            logger.info("--- Checking for updates to installed plugins ---");
            for (Bundle bundle : this.context.getBundles()) {
                this.checkForUpdateToBundle(bundle, 0);
            }
            logger.info("");
        }

        private void checkForDownloads(URL root) {
            logger.info("--- Searching plugins to install ---");
            this.processUpdateOrRepositoryDocumentAt(root, 0);
        }

        private void checkForUpdateToBundle(Bundle bundle, int depth) {
            String updateLocation = (String)bundle.getHeaders().get(PluginRegistryImpl.UPDATE_URL);
            if (updateLocation == null) {
                return;
            }
            try {
                URL url = new URL(updateLocation);
                Optional<Bundle> optionalBundle = Optional.ofNullable(bundle);
                UpdateChecker checker = new UpdateChecker(url, optionalBundle);
                Optional<PluginInfo> pluginInfo = checker.run();
                if (pluginInfo.isPresent()) {
                    PluginInfo info = pluginInfo.get();
                    Version installedVersion = bundle.getVersion();
                    Version availableVersion = info.getAvailableVersion();
                    if (availableVersion.compareTo((Object)installedVersion) > 0) {
                        this.updates.add(info);
                        this.selfUpdatingBundleIds.add(info.getId());
                        logger.info(AUTO_UPDATE, "{}Found update for {}.  Installed version: {}  Available version: {}", new Object[]{PluginRegistryImpl.pad(depth + 1), info.getId(), installedVersion, availableVersion});
                    }
                }
            }
            catch (PluginDocumentParseException e) {
                Object bundleName = bundle.getHeaders().get("Bundle-Name");
                logger.warn(AUTO_UPDATE, "The plugin update document for the {} plugin, which is located at {} could not be loaded/processed. Reason: {}", new Object[]{bundleName, updateLocation, e.getMessage()});
            }
            catch (MalformedURLException e) {
                logger.warn(AUTO_UPDATE, "The URL of the plugin document {} is malformed: {}", (Object)updateLocation, (Object)e.getMessage());
            }
        }

        private void processUpdateOrRepositoryDocumentAt(URL node, int depth) {
            if (this.visitedURLs.contains(node)) {
                return;
            }
            this.visitedURLs.add(node);
            logger.info(AUTO_UPDATE, "{}Checking {}", (Object)PluginRegistryImpl.pad(depth), (Object)node);
            UpdateChecker checker = new UpdateChecker(node, Optional.empty());
            try {
                Optional<PluginInfo> parsedInfo = checker.run();
                if (parsedInfo.isPresent()) {
                    Bundle bundle;
                    PluginInfo info = parsedInfo.get();
                    logger.debug(AUTO_UPDATE, "{}URL {} has valid plugin info: {}", new Object[]{PluginRegistryImpl.pad(depth), node, info.getId()});
                    if (!this.bundleByIds.containsKey(info.getId())) {
                        this.installs.add(info);
                        logger.debug(AUTO_UPDATE, "{}URL {} is a download", (Object)PluginRegistryImpl.pad(depth), (Object)node);
                    }
                    if ((bundle = this.bundleByIds.get(info.getId())) != null && bundle.getVersion().compareTo((Object)info.getAvailableVersion()) < 0 && !this.selfUpdatingBundleIds.contains(info.getId())) {
                        info.setPluginDescriptor(bundle);
                        this.updates.add(info);
                        logger.debug(AUTO_UPDATE, "{}URL {} is an update", (Object)PluginRegistryImpl.pad(depth), (Object)node);
                    }
                }
            }
            catch (PluginDocumentParseException e) {
                this.readRegistry(node, depth + 1);
            }
        }

        private void readRegistry(URL node, int depth) {
            logger.info(AUTO_UPDATE, "{}Processing {} as a plugin registry", (Object)PluginRegistryImpl.pad(depth), (Object)node);
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(node.openStream())));
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    if (logger.isDebugEnabled()) {
                        logger.debug(AUTO_UPDATE, "{}   reading line from node " + node + ":" + line, (Object)PluginRegistryImpl.pad(depth));
                    }
                    if (line.length() <= 0 || line.startsWith("//")) continue;
                    try {
                        URL url = new URL(line);
                        this.processUpdateOrRepositoryDocumentAt(url, depth + 1);
                    }
                    catch (MalformedURLException urlException) {
                        logger.debug(AUTO_UPDATE, "{}    Invalid URL in plugin registry: " + line, (Object)PluginRegistryImpl.pad(depth));
                    }
                }
                reader.close();
            }
            catch (IOException ex) {
                logger.warn(AUTO_UPDATE, "{}    Cannot open remote plugin registry at {}.  Reason: {}", new Object[]{PluginRegistryImpl.pad(depth), ex.getMessage(), ex});
            }
        }
    }

    public static enum PluginRegistryType {
        PLUGIN_UPDATE_REGISTRY("Updates"),
        PLUGIN_DOWNLOAD_REGISTRY("Downloads");

        private String label;

        private PluginRegistryType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

