/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Optional;
import org.osgi.framework.Bundle;
import org.protege.editor.core.plugin.PluginUtilities;
import org.protege.editor.core.update.PluginDocumentParseException;
import org.protege.editor.core.update.PluginInfo;
import org.protege.editor.core.update.PluginInfoDocumentParser;

public class UpdateChecker {
    private final URL url;
    private final Optional<Bundle> b;

    public UpdateChecker(URL updateFileURL, Optional<Bundle> pluginDescriptor) {
        this.url = (URL)Preconditions.checkNotNull((Object)updateFileURL);
        this.b = (Optional)Preconditions.checkNotNull(pluginDescriptor);
    }

    public Optional<PluginInfo> run() throws PluginDocumentParseException {
        PluginInfoDocumentParser pluginInfoDocumentParser = new PluginInfoDocumentParser(this.url);
        PluginInfo info = pluginInfoDocumentParser.parseDocument(this.b);
        if (!this.b.isPresent()) {
            info.setPluginDescriptor(null);
            return Optional.of(info);
        }
        if (info.getAvailableVersion().compareTo((Object)PluginUtilities.getBundleVersion(this.b.get())) > 0) {
            info.setPluginDescriptor(this.b.get());
            return Optional.of(info);
        }
        return Optional.empty();
    }
}

