/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleBuilder {
    private static final int BUFFER_SIZE = 10240;
    private final transient Logger logger = LoggerFactory.getLogger(BundleBuilder.class);
    public static final char JAR_SEPARATOR = '/';
    private File topLevelDirectory;
    private int topLevelDirectoryLength;
    private File manifest;

    public BundleBuilder(File directory) {
        this.topLevelDirectory = directory;
        String topLevel = this.topLevelDirectory.getAbsolutePath();
        this.topLevelDirectoryLength = topLevel.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJarFile(File jar) throws IOException {
        File manifest;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating jar file " + jar + " from directory " + this.topLevelDirectory);
        }
        if ((manifest = this.getManifest()) == null) {
            throw new IOException("No manifest found");
        }
        FileOutputStream fileOutputStream = null;
        FileInputStream manifestInputStream = null;
        ZipOutputStream jarOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(jar);
            manifestInputStream = new FileInputStream(manifest);
            jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, new Manifest(manifestInputStream));
            this.addDirectory((JarOutputStream)jarOutputStream, this.topLevelDirectory);
        }
        finally {
            if (jarOutputStream != null) {
                jarOutputStream.close();
            } else {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (manifestInputStream != null) {
                    manifestInputStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDirectory(JarOutputStream jar, File dir) throws IOException {
        for (File f : dir.listFiles()) {
            String path = this.calculatePath(f);
            if (f.isFile()) {
                if (f.equals(this.getManifest())) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Skipping manifest entry " + f);
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Adding entry for file " + f + " with path " + path);
                }
                JarEntry entry = new JarEntry(path);
                jar.putNextEntry(entry);
                byte[] buffer = new byte[10240];
                try (FileInputStream input = new FileInputStream(f);){
                    int readCount = 0;
                    while ((readCount = input.read(buffer)) > 0) {
                        jar.write(buffer, 0, readCount);
                    }
                    continue;
                }
            }
            this.addDirectory(jar, f);
        }
    }

    private String calculatePath(File f) {
        String path = f.getAbsolutePath().substring(this.topLevelDirectoryLength + 1);
        path = path.replace(File.separatorChar, '/');
        return path;
    }

    private File getManifest() {
        if (this.manifest == null) {
            this.manifest = new File(this.topLevelDirectory, "META-INF/MANIFEST.MF");
            if (this.manifest.exists()) {
                return this.manifest;
            }
            this.manifest = new File(this.topLevelDirectory, "meta-inf/manifest.mf");
            if (this.manifest.exists()) {
                return this.manifest;
            }
        }
        return this.manifest;
    }
}

