/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.concurrent;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.protege.owlapi.concurrent.WriteSafeOWLOntology;
import org.protege.owlapi.concurrent.WriteSafeOWLOntologyImpl;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class WriteSafeOWLOntologyFactory
implements OWLOntologyFactory {
    private OWLOntologyFactory delegate;
    private ReentrantReadWriteLock lock;

    public WriteSafeOWLOntologyFactory(OWLOntologyFactory delegate, ReentrantReadWriteLock lock) {
        this.delegate = delegate;
        this.lock = lock;
    }

    private OWLOntology wrapOntology(OWLOntology ontology) {
        if (ontology instanceof OWLMutableOntology && !(ontology instanceof WriteSafeOWLOntology)) {
            WriteSafeOWLOntologyImpl wrappedOntology = new WriteSafeOWLOntologyImpl((OWLMutableOntology)ontology);
            wrappedOntology.setLocks(this.lock);
            return wrappedOntology;
        }
        return ontology;
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean canCreateFromDocumentIRI(IRI documentIRI) {
        return this.delegate.canCreateFromDocumentIRI(documentIRI);
    }

    public boolean canLoad(OWLOntologyDocumentSource documentSource) {
        return this.delegate.canLoad(documentSource);
    }

    public OWLOntology createOWLOntology(OWLOntologyID ontologyID, IRI documentIRI, OWLOntologyFactory.OWLOntologyCreationHandler handler) throws OWLOntologyCreationException {
        return this.wrapOntology(this.delegate.createOWLOntology(ontologyID, documentIRI, (OWLOntologyFactory.OWLOntologyCreationHandler)new WrappedOntologyCreationHandler(handler)));
    }

    public OWLOntology loadOWLOntology(OWLOntologyDocumentSource documentSource, OWLOntologyFactory.OWLOntologyCreationHandler handler) throws OWLOntologyCreationException {
        return this.wrapOntology(this.delegate.loadOWLOntology(documentSource, (OWLOntologyFactory.OWLOntologyCreationHandler)new WrappedOntologyCreationHandler(handler)));
    }

    public void setOWLOntologyManager(OWLOntologyManager owlOntologyManager) {
        this.delegate.setOWLOntologyManager(owlOntologyManager);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.delegate.getOWLOntologyManager();
    }

    public OWLOntology loadOWLOntology(OWLOntologyDocumentSource documentSource, OWLOntologyFactory.OWLOntologyCreationHandler handler, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        return this.wrapOntology(this.delegate.loadOWLOntology(documentSource, (OWLOntologyFactory.OWLOntologyCreationHandler)new WrappedOntologyCreationHandler(handler), configuration));
    }

    private class WrappedOntologyCreationHandler
    implements OWLOntologyFactory.OWLOntologyCreationHandler {
        private OWLOntologyFactory.OWLOntologyCreationHandler delegate;

        public WrappedOntologyCreationHandler(OWLOntologyFactory.OWLOntologyCreationHandler delegate) {
            this.delegate = delegate;
        }

        public void ontologyCreated(OWLOntology ontology) {
            this.delegate.ontologyCreated(WriteSafeOWLOntologyFactory.this.wrapOntology(ontology));
        }

        public void setOntologyFormat(OWLOntology ontology, OWLOntologyFormat format) {
            this.delegate.setOntologyFormat(WriteSafeOWLOntologyFactory.this.wrapOntology(ontology), format);
        }
    }
}

