/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.inconsistent;

import com.clarkparsia.owlapi.explanation.BlackBoxExplanation;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.owlapi.inconsistent.OntologySplitter;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;

public class Phase01 {
    public static final Logger LOGGER = Logger.getLogger(Phase01.class);
    private boolean reasonerActive = false;
    private boolean isCancelled = false;
    private OWLOntology ontology;
    private OWLReasonerFactory reasonerFactory;
    private OntologySplitter splitter;
    private OWLOntology consistentOntology;
    private OWLOntology otherPartOntology;
    private OWLOntology surrogateTypeOntology;
    private OWLReasoner reasoner;
    private Set<OWLClass> inconsistentClasses;
    private Set<OWLIndividual> inconsistentIndividuals;

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLOntology getConsistentOntology() {
        return this.consistentOntology;
    }

    public OWLOntology getOtherPartOntology() {
        return this.otherPartOntology;
    }

    public OWLOntology getSurrogateTypeOntology() {
        return this.surrogateTypeOntology;
    }

    public OWLOntology getHotspots() {
        return this.splitter.getHotSpotPart();
    }

    public Set<OWLClass> getInconsistentClasses() {
        return this.inconsistentClasses;
    }

    public Set<OWLIndividual> getInconsistentIndividuals() {
        return this.inconsistentIndividuals;
    }

    public OWLReasoner getReasoner() {
        return this.reasoner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(OWLOntology ontology, OWLReasonerFactory reasonerFactory) throws OWLOntologyCreationException {
        Set entities;
        Phase01 phase01 = this;
        synchronized (phase01) {
            if (this.isCancelled) {
                return false;
            }
        }
        this.ontology = ontology;
        OWLDataFactory factory = ontology.getOWLOntologyManager().getOWLDataFactory();
        this.reasonerFactory = reasonerFactory;
        this.splitter = new OntologySplitter();
        this.splitter.split(ontology, reasonerFactory);
        this.consistentOntology = this.splitter.getConsistentPart();
        this.otherPartOntology = this.splitter.getOtherPart();
        this.surrogateTypeOntology = this.splitter.getSurrogateTypePart();
        this.reasoner = reasonerFactory.createReasoner(this.surrogateTypeOntology);
        this.inconsistentClasses = new HashSet<OWLClass>();
        this.inconsistentIndividuals = new HashSet<OWLIndividual>();
        Phase01 phase012 = this;
        synchronized (phase012) {
            if (this.isCancelled) {
                return false;
            }
            this.reasonerActive = true;
        }
        try {
            entities = this.reasoner.getBottomClassNode().getEntities();
        }
        catch (ReasonerInterruptedException interrupt) {
            LOGGER.info((Object)"Reasoning process was interrupted - aborting explanation.");
            return false;
        }
        Phase01 interrupt = this;
        synchronized (interrupt) {
            this.reasonerActive = false;
        }
        for (OWLClass c : entities) {
            if (c.equals(factory.getOWLNothing())) continue;
            OWLIndividual i = this.splitter.getTypeCollector().getTypedIndividual(c);
            if (i != null) {
                this.inconsistentIndividuals.add(i);
                continue;
            }
            this.inconsistentClasses.add(c);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Phase01 phase01 = this;
        synchronized (phase01) {
            this.isCancelled = true;
            if (this.reasonerActive) {
                this.reasoner.interrupt();
            }
        }
    }

    public void reset() {
        this.isCancelled = false;
        this.reasonerActive = false;
    }

    public void dispose() {
        if (this.reasoner != null) {
            this.reasoner.dispose();
        }
    }

    public Set<OWLAxiom> explain(OWLClass cls) {
        BlackBoxExplanation teacher = new BlackBoxExplanation(this.consistentOntology, this.reasonerFactory, this.reasoner);
        return teacher.getExplanation((OWLClassExpression)cls);
    }

    public Set<OWLAxiom> explain(OWLIndividual i) {
        BlackBoxExplanation teacher = new BlackBoxExplanation(this.surrogateTypeOntology, this.reasonerFactory, this.reasoner);
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        OWLClass type = this.splitter.getTypeCollector().getSurrogateType(i);
        for (OWLAxiom axiom : teacher.getExplanation((OWLClassExpression)type)) {
            OWLAxiom originalAxiom = this.splitter.getOriginalAxiom(axiom);
            if (originalAxiom != null) {
                axioms.add(originalAxiom);
                continue;
            }
            if (this.splitter.getTypeCollector().getSingletonAxioms().contains(axiom)) continue;
            axioms.add(axiom);
        }
        return axioms;
    }

    public File saveOntologies(File parent) throws OWLOntologyStorageException {
        return this.splitter.saveOntologies(parent);
    }
}

