/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.inconsistent.trivialModel;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.protege.owlapi.inconsistent.Util;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class TrivialModel {
    private OWLOntology ontology;
    private Set<OWLIndividual> allIndividuals;
    private OWLDataFactory factory;
    private OWLReasoner reasoner;
    private OWLDataProperty dp;

    public TrivialModel(OWLOntology ontology, OWLReasonerFactory reasonerFactory) throws OWLOntologyCreationException {
        this.ontology = ontology;
        this.initializeIndividuals();
        this.initializeDataReasoner(reasonerFactory);
    }

    private void initializeIndividuals() {
        this.allIndividuals = new HashSet<OWLIndividual>();
        this.allIndividuals.addAll(this.ontology.getIndividualsInSignature(true));
        for (OWLOntology inClosure : this.ontology.getImportsClosure()) {
            this.allIndividuals.addAll(inClosure.getReferencedAnonymousIndividuals());
        }
        if (this.allIndividuals.isEmpty()) {
            OWLDataFactory factory = this.ontology.getOWLOntologyManager().getOWLDataFactory();
            this.allIndividuals.add((OWLIndividual)Util.generateRandomEntity(factory, EntityType.NAMED_INDIVIDUAL));
        }
    }

    private void initializeDataReasoner(OWLReasonerFactory reasonerFactory) throws OWLOntologyCreationException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        this.factory = manager.getOWLDataFactory();
        OWLOntology ontology = manager.createOntology();
        this.dp = (OWLDataProperty)Util.generateRandomEntity(this.factory, EntityType.DATA_PROPERTY);
        manager.addAxiom(ontology, (OWLAxiom)this.factory.getOWLDeclarationAxiom((OWLEntity)this.dp));
        this.reasoner = reasonerFactory.createReasoner(ontology);
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public Set<OWLIndividual> getAllIndividuals() {
        return Collections.unmodifiableSet(this.allIndividuals);
    }

    public boolean isTopClass(OWLClass c) {
        return c.equals(this.factory.getOWLThing());
    }

    public boolean isTopProperty(OWLObjectPropertyExpression pe) {
        return pe.getNamedProperty().equals(this.factory.getOWLTopObjectProperty());
    }

    public boolean isTopProperty(OWLDataPropertyExpression pe) {
        return pe.equals(this.factory.getOWLTopDataProperty());
    }

    public boolean isTopDataRange(OWLDataRange range) {
        return !this.reasoner.isSatisfiable((OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)this.factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)this.dp, range)));
    }

    public boolean isConsistent(OWLDataRange range) {
        return this.reasoner.isSatisfiable((OWLClassExpression)this.factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)this.dp, range));
    }

    public boolean hasAtLeast(OWLDataRange range, int cardinality) {
        return this.reasoner.isSatisfiable((OWLClassExpression)this.factory.getOWLDataMinCardinality(cardinality, (OWLDataPropertyExpression)this.dp, range));
    }

    public boolean hasNoMoreThan(OWLDataRange range, int cardinality) {
        return this.reasoner.isSatisfiable((OWLClassExpression)this.factory.getOWLDataMaxCardinality(cardinality, (OWLDataPropertyExpression)this.dp, range));
    }

    public boolean hasExactly(OWLDataRange range, int cardinality) {
        return this.reasoner.isSatisfiable((OWLClassExpression)this.factory.getOWLDataExactCardinality(cardinality, (OWLDataPropertyExpression)this.dp, range));
    }
}

