/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.SwingUtilities;
import org.protege.owlapi.concurrent.WriteSafeOWLOntologyFactory;
import org.protege.owlapi.model.WriteSafeOWLOntologyManager;
import org.protege.owlapi.util.SaveResultsRunnable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLOntologyManagerImpl;

public class ProtegeOWLOntologyManager
extends OWLOntologyManagerImpl
implements WriteSafeOWLOntologyManager {
    private static final long serialVersionUID = -6371104970223669912L;
    private boolean useWriteSafety = false;
    private boolean useSwingThread = false;
    private List<OWLOntologyFactory> ontologyFactories = new ArrayList<OWLOntologyFactory>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ProtegeOWLOntologyManager(OWLDataFactory factory) {
        super(factory);
    }

    public void setUseWriteSafety(boolean useWriteSafety) {
        this.useWriteSafety = useWriteSafety;
    }

    public boolean isUseWriteSafety() {
        return this.useWriteSafety;
    }

    public boolean isUseSwingThread() {
        return this.useSwingThread;
    }

    public void setUseSwingThread(boolean useSwingThread) {
        this.useSwingThread = useSwingThread;
    }

    @Override
    public ReentrantReadWriteLock getReadWriteLock() {
        return this.lock;
    }

    @Override
    public ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.lock.readLock();
    }

    @Override
    public ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.lock.writeLock();
    }

    public List<OWLOntologyFactory> getOWLOntologyFactories() {
        return new ArrayList<OWLOntologyFactory>(this.ontologyFactories);
    }

    public void addOntologyFactory(OWLOntologyFactory factory) {
        factory = this.wrapFactory(factory);
        super.addOntologyFactory(factory);
        this.ontologyFactories.add(0, factory);
    }

    public void removeOntologyFactory(OWLOntologyFactory factory) {
        factory = this.wrapFactory(factory);
        super.removeOntologyFactory(factory);
        this.ontologyFactories.remove(factory);
    }

    private OWLOntologyFactory wrapFactory(OWLOntologyFactory factory) {
        if (this.useWriteSafety && !(factory instanceof WriteSafeOWLOntologyFactory)) {
            factory = new WriteSafeOWLOntologyFactory(factory, this.lock);
        }
        return factory;
    }

    public void clearOntologyFactories() {
        for (OWLOntologyFactory factory : new ArrayList<OWLOntologyFactory>(this.ontologyFactories)) {
            this.removeOntologyFactory(factory);
        }
    }

    private List<OWLOntologyChange> addAxiomsSuper(OWLOntology ont, Set<? extends OWLAxiom> axioms) {
        return super.addAxioms(ont, axioms);
    }

    public List<OWLOntologyChange> addAxioms(final OWLOntology ont, final Set<? extends OWLAxiom> axioms) {
        return this.callWithWriteLockUnchecked(new Callable<List<OWLOntologyChange>>(){

            @Override
            public List<OWLOntologyChange> call() {
                return ProtegeOWLOntologyManager.this.addAxiomsSuper(ont, axioms);
            }
        });
    }

    private List<OWLOntologyChange> removeAxiomsSuper(OWLOntology ont, Set<? extends OWLAxiom> axioms) {
        return super.removeAxioms(ont, axioms);
    }

    public List<OWLOntologyChange> removeAxioms(final OWLOntology ont, final Set<? extends OWLAxiom> axioms) {
        return this.callWithWriteLockUnchecked(new Callable<List<OWLOntologyChange>>(){

            @Override
            public List<OWLOntologyChange> call() {
                return ProtegeOWLOntologyManager.this.removeAxiomsSuper(ont, axioms);
            }
        });
    }

    private List<OWLOntologyChange> applyChangeSuper(OWLOntologyChange change) {
        return super.applyChange(change);
    }

    public List<OWLOntologyChange> applyChange(final OWLOntologyChange change) {
        return this.callWithWriteLockUnchecked(new Callable<List<OWLOntologyChange>>(){

            @Override
            public List<OWLOntologyChange> call() {
                return ProtegeOWLOntologyManager.this.applyChangeSuper(change);
            }
        });
    }

    private List<OWLOntologyChange> applyChangesSuper(List<? extends OWLOntologyChange> changes) {
        return super.applyChanges(changes);
    }

    public List<OWLOntologyChange> applyChanges(final List<? extends OWLOntologyChange> changes) {
        return this.callWithWriteLockUnchecked(new Callable<List<OWLOntologyChange>>(){

            @Override
            public List<OWLOntologyChange> call() {
                return ProtegeOWLOntologyManager.this.applyChangesSuper(changes);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> X callWithWriteLock(Callable<X> call) throws Exception {
        if (this.useSwingThread && !SwingUtilities.isEventDispatchThread()) {
            final SaveResultsRunnable<X> run = new SaveResultsRunnable<X>(call);
            SwingUtilities.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProtegeOWLOntologyManager.this.lock.writeLock().lock();
                    try {
                        run.run();
                    }
                    finally {
                        ProtegeOWLOntologyManager.this.lock.writeLock().unlock();
                    }
                }
            });
            if (run.getException() != null) {
                throw run.getException();
            }
            return run.getResult();
        }
        this.lock.writeLock().lock();
        try {
            X x = call.call();
            return x;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public <X> X callWithWriteLockUnchecked(Callable<X> call) {
        try {
            return this.callWithWriteLock(call);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

