/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.rdf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.protege.owlapi.rdf.ProblemReport;
import org.protege.owlapi.rdf.report.ImportsBrokenOntologies;
import org.protege.owlapi.rdf.report.MisreadAnnotationDomainAxiom;
import org.protege.owlapi.rdf.report.MisreadAnnotationRangeAxiom;
import org.protege.owlapi.rdf.report.MissingRequiredDeclarations;
import org.protege.owlapi.rdf.report.PunnedProperties;
import org.protege.owlapi.util.ImportsClosureComparator;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static Logger LOGGER = LoggerFactory.getLogger(Validator.class);

    public String generateFullReport(OWLOntology ontology) {
        return this.generateFullReport(this.analyze(ontology));
    }

    public String generateFullReport(Map<OWLOntology, List<ProblemReport>> problems) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>\n<body>\n<h2>Ontology Validation Report</h2>\n<p>\n");
        for (Map.Entry<OWLOntology, List<ProblemReport>> entry : problems.entrySet()) {
            OWLOntology badOntology = entry.getKey();
            List<ProblemReport> reports = entry.getValue();
            sb.append("<h2>");
            sb.append(badOntology.getOntologyID().getOntologyIRI().toString());
            sb.append("</h2>\n");
            sb.append("This ontology has the following problems:\n<p>\n");
            for (ProblemReport report : reports) {
                sb.append("\t" + report.getDetailedDescription() + "\n\n");
                sb.append("<p>\n");
            }
        }
        sb.append("</body>\n</html>\n");
        return sb.toString();
    }

    public Map<OWLOntology, List<ProblemReport>> analyze(OWLOntology ontology) {
        TreeMap<OWLOntology, List<ProblemReport>> problems = new TreeMap<OWLOntology, List<ProblemReport>>();
        ArrayList toAnalyze = new ArrayList(ontology.getImportsClosure());
        Collections.sort(toAnalyze, new ImportsClosureComparator());
        for (OWLOntology ontologyBeingAnalyzed : toAnalyze) {
            if (problems.containsKey(ontologyBeingAnalyzed)) continue;
            this.check(ontologyBeingAnalyzed, problems);
        }
        return problems;
    }

    private void check(OWLOntology ontology, Map<OWLOntology, List<ProblemReport>> problems) {
        if (problems.containsKey(ontology)) {
            return;
        }
        if (!this.checkImportsClosure(ontology, problems)) {
            return;
        }
        this.checkForBadDomainAxiom(ontology, problems);
        this.checkForBadRangeAxiom(ontology, problems);
        this.checkContainsRequiredDeclarations(ontology, problems);
        this.checkForPropertyPuns(ontology, problems);
    }

    private boolean checkImportsClosure(OWLOntology ontology, Map<OWLOntology, List<ProblemReport>> problems) {
        ArrayList<OWLOntology> badImports = new ArrayList<OWLOntology>();
        for (OWLOntology inImportsClosure : ontology.getImportsClosure()) {
            if (!problems.containsKey(inImportsClosure)) continue;
            badImports.add(inImportsClosure);
        }
        if (!badImports.isEmpty()) {
            Validator.addProblemReport(new ImportsBrokenOntologies(ontology, badImports), problems);
        }
        return badImports.isEmpty();
    }

    private void checkContainsRequiredDeclarations(OWLOntology ontology, Map<OWLOntology, List<ProblemReport>> problems) {
        OWLDataFactory factory = ontology.getOWLOntologyManager().getOWLDataFactory();
        TreeSet<OWLEntity> entitiesWithoutDeclarations = new TreeSet<OWLEntity>();
        for (OWLEntity e : ontology.getSignature()) {
            OWLDeclarationAxiom declaration;
            if (e instanceof OWLNamedIndividual || e.isBuiltIn() || ontology.containsAxiom((OWLAxiom)(declaration = factory.getOWLDeclarationAxiom(e)), true)) continue;
            entitiesWithoutDeclarations.add(e);
        }
        if (!entitiesWithoutDeclarations.isEmpty()) {
            Validator.addProblemReport(new MissingRequiredDeclarations(ontology, entitiesWithoutDeclarations), problems);
        }
    }

    private void checkForBadDomainAxiom(OWLOntology ontology, Map<OWLOntology, List<ProblemReport>> problems) {
        OWLDataFactory factory = ontology.getOWLOntologyManager().getOWLDataFactory();
        for (OWLAnnotationPropertyDomainAxiom axiom : ontology.getAxioms(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            OWLAnnotationProperty annotationProperty = axiom.getProperty();
            OWLDeclarationAxiom annotationDeclaration = factory.getOWLDeclarationAxiom((OWLEntity)annotationProperty);
            OWLDeclarationAxiom classDeclaration = factory.getOWLDeclarationAxiom((OWLEntity)factory.getOWLClass(axiom.getDomain()));
            if (ontology.containsAxiom((OWLAxiom)annotationDeclaration, true) || !ontology.containsObjectPropertyInSignature(annotationProperty.getIRI(), true) || ontology.containsAxiom((OWLAxiom)classDeclaration, true)) continue;
            Validator.addProblemReport(new MisreadAnnotationDomainAxiom(ontology, axiom), problems);
        }
    }

    private void checkForBadRangeAxiom(OWLOntology ontology, Map<OWLOntology, List<ProblemReport>> problems) {
        OWLDataFactory factory = ontology.getOWLOntologyManager().getOWLDataFactory();
        for (OWLAnnotationPropertyRangeAxiom axiom : ontology.getAxioms(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            OWLAnnotationProperty annotationProperty = axiom.getProperty();
            OWLDeclarationAxiom annotationDeclaration = factory.getOWLDeclarationAxiom((OWLEntity)annotationProperty);
            OWLDeclarationAxiom classDeclaration = factory.getOWLDeclarationAxiom((OWLEntity)factory.getOWLClass(axiom.getRange()));
            if (ontology.containsAxiom((OWLAxiom)annotationDeclaration, true) || !ontology.containsObjectPropertyInSignature(annotationProperty.getIRI(), true) || ontology.containsAxiom((OWLAxiom)classDeclaration, true)) continue;
            Validator.addProblemReport(new MisreadAnnotationRangeAxiom(ontology, axiom), problems);
        }
    }

    private void checkForPropertyPuns(OWLOntology ontology, Map<OWLOntology, List<ProblemReport>> problems) {
        TreeSet<IRI> punnedIris = new TreeSet<IRI>();
        for (OWLAnnotationProperty p : ontology.getAnnotationPropertiesInSignature()) {
            if (ontology.containsObjectPropertyInSignature(p.getIRI())) {
                punnedIris.add(p.getIRI());
                continue;
            }
            if (!ontology.containsDataPropertyInSignature(p.getIRI())) continue;
            punnedIris.add(p.getIRI());
        }
        for (OWLAnnotationProperty p : ontology.getObjectPropertiesInSignature()) {
            if (!ontology.containsDataPropertyInSignature(p.getIRI())) continue;
            punnedIris.add(p.getIRI());
        }
        if (!punnedIris.isEmpty()) {
            TreeMap<IRI, Collection<EntityType>> propertyPunMap = new TreeMap<IRI, Collection<EntityType>>();
            for (IRI iri : punnedIris) {
                ArrayList<EntityType> types = new ArrayList<EntityType>();
                if (ontology.containsAnnotationPropertyInSignature(iri)) {
                    types.add(EntityType.ANNOTATION_PROPERTY);
                }
                if (ontology.containsObjectPropertyInSignature(iri)) {
                    types.add(EntityType.OBJECT_PROPERTY);
                } else if (ontology.containsDataPropertyInSignature(iri)) {
                    types.add(EntityType.DATA_PROPERTY);
                }
                propertyPunMap.put(iri, types);
            }
            Validator.addProblemReport(new PunnedProperties(ontology, propertyPunMap), problems);
        }
    }

    private static void addProblemReport(ProblemReport report, Map<OWLOntology, List<ProblemReport>> problems) {
        OWLOntology ontology = report.getOntology();
        List<ProblemReport> reports = problems.get(ontology);
        if (reports == null) {
            reports = new ArrayList<ProblemReport>();
            problems.put(ontology, reports);
        }
        reports.add(report);
    }
}

