/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.authorization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import edu.stanford.protege.webprotege.common.UserId;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=SpecificUser.class), @JsonSubTypes.Type(value=AnySignedInUser.class)})
public abstract class Subject {
    private Subject() {
    }

    @JsonIgnore
    public abstract boolean isGuest();

    @JsonIgnore
    public abstract boolean isAnySignedInUser();

    @Nonnull
    @JsonIgnore
    public abstract Optional<String> getUserName();

    public abstract Optional<UserId> getUserId();

    public static Subject forAnySignedInUser() {
        return AnySignedInUser.INSTANCE;
    }

    public static Subject forUser(@Nonnull UserId userId) {
        return new SpecificUser(userId);
    }

    public static Subject forUser(@Nonnull String userId) {
        return Subject.forUser(UserId.valueOf((String)userId));
    }

    public static Subject forGuestUser() {
        return SpecificUser.GUEST;
    }

    @JsonTypeName(value="AnyUser")
    protected static class AnySignedInUser
    extends Subject {
        private static final AnySignedInUser INSTANCE = new AnySignedInUser();

        @JsonCreator
        public AnySignedInUser() {
        }

        @Override
        public boolean isGuest() {
            return false;
        }

        @Override
        public boolean isAnySignedInUser() {
            return true;
        }

        @Override
        @Nonnull
        public Optional<String> getUserName() {
            return Optional.empty();
        }

        @Override
        public Optional<UserId> getUserId() {
            return Optional.empty();
        }

        public int hashCode() {
            return 33;
        }

        public boolean equals(Object obj) {
            return obj instanceof AnySignedInUser;
        }

        public String toString() {
            return "AnySignedInUser{}";
        }
    }

    @JsonTypeName(value="User")
    protected static class SpecificUser
    extends Subject {
        private static final SpecificUser GUEST = new SpecificUser(UserId.getGuest());
        private final UserId userId;

        public SpecificUser(UserId userId) {
            this.userId = Objects.requireNonNull(userId);
        }

        @JsonCreator
        public static SpecificUser forUser(@JsonProperty(value="userId") String userId) {
            Objects.requireNonNull(userId);
            return new SpecificUser(UserId.valueOf((String)userId));
        }

        @Override
        public boolean isGuest() {
            return this.userId.isGuest();
        }

        @Override
        @Nonnull
        public Optional<String> getUserName() {
            return Optional.of(this.userId.id());
        }

        @Override
        public Optional<UserId> getUserId() {
            return Optional.of(this.userId);
        }

        @Override
        public boolean isAnySignedInUser() {
            return false;
        }

        public int hashCode() {
            return this.userId.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SpecificUser)) {
                return false;
            }
            SpecificUser other = (SpecificUser)obj;
            return this.userId.equals((Object)other.userId);
        }

        public String toString() {
            return "SpecificUser{userId=" + this.userId + "}";
        }
    }
}

