/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.authorization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import edu.stanford.protege.webprotege.authorization.Resource;
import edu.stanford.protege.webprotege.common.ProjectId;
import java.util.Objects;
import java.util.Optional;

@JsonTypeName(value="Project")
public final class ProjectResource
implements Resource {
    private final ProjectId projectId;

    public ProjectResource(ProjectId projectId) {
        Objects.requireNonNull(projectId.id());
        this.projectId = Objects.requireNonNull(projectId);
    }

    public static ProjectResource forProject(ProjectId projectId) {
        return new ProjectResource(projectId);
    }

    @JsonCreator
    public static ProjectResource forProject(@JsonProperty(value="projectId") String projectId) {
        return new ProjectResource(ProjectId.valueOf((String)projectId));
    }

    @Override
    public Optional<ProjectId> getProjectId() {
        return Optional.of(this.projectId);
    }

    @Override
    public boolean isProject(ProjectId projectId) {
        return this.projectId.equals((Object)projectId);
    }

    @Override
    public boolean isProject() {
        return true;
    }

    @Override
    public boolean isApplication() {
        return false;
    }

    public int hashCode() {
        return this.projectId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProjectResource)) {
            return false;
        }
        ProjectResource other = (ProjectResource)obj;
        return this.projectId.equals((Object)other.projectId);
    }

    public String toString() {
        return "ProjectResource{projectId=" + String.valueOf(this.projectId) + "}";
    }
}

