/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.authorization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.stanford.protege.webprotege.authorization.Capability;
import edu.stanford.protege.webprotege.authorization.RoleId;
import edu.stanford.protege.webprotege.authorization.RoleType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public record RoleDefinition(@Nonnull @JsonProperty(value="roleId") RoleId roleId, @Nonnull @JsonProperty(value="roleType") RoleType roleType, @Nonnull @JsonProperty(value="parentRoles") Set<RoleId> parentRoles, @Nonnull @JsonProperty(value="roleCapabilities") Set<Capability> roleCapabilities, @Nonnull @JsonProperty(value="label") String label, @Nonnull @JsonProperty(value="description") String description) {
    public RoleDefinition(@Nonnull @JsonProperty(value="roleId") RoleId roleId, @Nonnull @JsonProperty(value="roleType") RoleType roleType, @Nonnull @JsonProperty(value="parentRoles") Set<RoleId> parentRoles, @Nonnull @JsonProperty(value="roleCapabilities") Set<Capability> roleCapabilities, @Nonnull @JsonProperty(value="label") String label, @Nonnull @JsonProperty(value="description") String description) {
        this.roleId = Objects.requireNonNull(roleId);
        this.roleType = Objects.requireNonNull(roleType);
        this.parentRoles = Set.copyOf((Collection)Objects.requireNonNull(parentRoles));
        this.roleCapabilities = Set.copyOf((Collection)Objects.requireNonNull(roleCapabilities));
        this.label = Objects.requireNonNull(label);
        this.description = Objects.requireNonNull(description);
    }

    @JsonCreator
    public static RoleDefinition get(@JsonProperty(value="roleId") RoleId roleId, @JsonProperty(value="roleType") RoleType roleType, @JsonProperty(value="parentRoles") Set<RoleId> parentRoles, @JsonProperty(value="roleCapabilities") Set<Capability> roleCapabilities, @JsonProperty(value="label") String label, @JsonProperty(value="description") String description) {
        return new RoleDefinition(roleId, roleType, parentRoles, roleCapabilities, Objects.requireNonNullElse(label, ""), description);
    }

    public RoleDefinition withoutCapabilities(Predicate<Capability> filter) {
        Set<Capability> remainingCapabilities = this.roleCapabilities.stream().filter(Predicate.not(filter)).collect(Collectors.toSet());
        return new RoleDefinition(this.roleId, this.roleType, this.parentRoles, remainingCapabilities, this.label, this.description);
    }

    public RoleDefinition addCapabilities(Collection<? extends Capability> capabilities) {
        LinkedHashSet<Capability> combinedCapabilities = new LinkedHashSet<Capability>(this.roleCapabilities);
        combinedCapabilities.addAll(capabilities);
        return new RoleDefinition(this.roleId, this.roleType, this.parentRoles, combinedCapabilities, this.label, this.description);
    }
}

