/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.app;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class ApplicationLocation {
    private String scheme;
    private String host;
    private String path;
    private int port;

    private ApplicationLocation() {
    }

    public ApplicationLocation(@Nonnull String scheme, @Nonnull String host, @Nonnull String path, int port) {
        this.scheme = (String)Preconditions.checkNotNull((Object)scheme);
        this.host = (String)Preconditions.checkNotNull((Object)host);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.port = port;
    }

    @Nonnull
    public String getScheme() {
        return this.scheme;
    }

    @Nonnull
    public String getHost() {
        return this.host;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.scheme, this.host, this.path, this.port});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApplicationLocation)) {
            return false;
        }
        ApplicationLocation other = (ApplicationLocation)obj;
        return this.scheme.equals(other.scheme) && this.host.equals(other.host) && this.path.equals(other.path) && this.port == other.port;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ApplicationLocation").add("scheme", (Object)this.scheme).add("host", (Object)this.host).add("path", (Object)this.path).add("port", this.port).toString();
    }
}

