/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.app;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.app.AccountCreationSetting;
import edu.stanford.protege.webprotege.app.ApplicationLocation;
import edu.stanford.protege.webprotege.app.NotificationEmailsSetting;
import edu.stanford.protege.webprotege.app.ProjectCreationSetting;
import edu.stanford.protege.webprotege.app.ProjectUploadSetting;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.user.EmailAddress;
import java.util.List;
import javax.annotation.Nonnull;

@JsonClassDescription(value="An object that represents the application settings")
public class ApplicationSettings {
    private final String applicationName;
    private final EmailAddress systemNotificationEmailAddress;
    private final ApplicationLocation applicationLocation;
    private final AccountCreationSetting accountCreationSetting;
    private final List<UserId> accountCreators;
    private final ProjectCreationSetting projectCreationSetting;
    private final List<UserId> projectCreators;
    private final ProjectUploadSetting projectUploadSetting;
    private final List<UserId> projectUploaders;
    private final NotificationEmailsSetting notificationEmailsSetting;
    private final long maxUploadSize;

    public ApplicationSettings(@Nonnull String applicationName, @Nonnull EmailAddress systemNotificationEmailAddress, @Nonnull ApplicationLocation applicationLocation, @Nonnull AccountCreationSetting accountCreationSetting, @Nonnull List<UserId> accountCreators, @Nonnull ProjectCreationSetting projectCreationSetting, @Nonnull List<UserId> projectCreators, @Nonnull ProjectUploadSetting projectUploadSetting, @Nonnull List<UserId> projectUploaders, @Nonnull NotificationEmailsSetting notificationEmailsSetting, long maxUploadSize) {
        this.applicationName = (String)Preconditions.checkNotNull((Object)applicationName);
        this.systemNotificationEmailAddress = (EmailAddress)Preconditions.checkNotNull((Object)systemNotificationEmailAddress);
        this.applicationLocation = (ApplicationLocation)Preconditions.checkNotNull((Object)applicationLocation);
        this.accountCreationSetting = (AccountCreationSetting)((Object)Preconditions.checkNotNull((Object)((Object)accountCreationSetting)));
        this.accountCreators = (List)Preconditions.checkNotNull(accountCreators);
        this.projectCreationSetting = (ProjectCreationSetting)((Object)Preconditions.checkNotNull((Object)((Object)projectCreationSetting)));
        this.projectCreators = (List)Preconditions.checkNotNull(projectCreators);
        this.projectUploadSetting = (ProjectUploadSetting)((Object)Preconditions.checkNotNull((Object)((Object)projectUploadSetting)));
        this.projectUploaders = (List)Preconditions.checkNotNull(projectUploaders);
        this.notificationEmailsSetting = (NotificationEmailsSetting)((Object)Preconditions.checkNotNull((Object)((Object)notificationEmailsSetting)));
        this.maxUploadSize = maxUploadSize;
    }

    @JsonPropertyDescription(value="The human readable application name")
    @Nonnull
    public String getApplicationName() {
        return this.applicationName;
    }

    @JsonPropertyDescription(value="An email address that critical system notifications will be sent to")
    @Nonnull
    public EmailAddress getSystemNotificationEmailAddress() {
        return this.systemNotificationEmailAddress;
    }

    @Nonnull
    public AccountCreationSetting getAccountCreationSetting() {
        return this.accountCreationSetting;
    }

    @JsonPropertyDescription(value="A list of users that are allowed to create accounts.  May be empty.")
    @Nonnull
    public List<UserId> getAccountCreators() {
        return this.accountCreators;
    }

    @Nonnull
    public ProjectCreationSetting getProjectCreationSetting() {
        return this.projectCreationSetting;
    }

    @JsonPropertyDescription(value="A list of users that are allowed to create projects.  May be empty.")
    @Nonnull
    public List<UserId> getProjectCreators() {
        return this.projectCreators;
    }

    @Nonnull
    public ProjectUploadSetting getProjectUploadSetting() {
        return this.projectUploadSetting;
    }

    @JsonPropertyDescription(value="A list of users that are allowed to upload ontologies.  May be empty.")
    @Nonnull
    public List<UserId> getProjectUploaders() {
        return this.projectUploaders;
    }

    @Nonnull
    public NotificationEmailsSetting getNotificationEmailsSetting() {
        return this.notificationEmailsSetting;
    }

    @JsonPropertyDescription(value="An object that represents the Web location of the application.")
    @Nonnull
    public ApplicationLocation getApplicationLocation() {
        return this.applicationLocation;
    }

    @JsonPropertyDescription(value="The maximum upload size in Megabytes")
    public long getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.applicationName, this.systemNotificationEmailAddress, this.applicationLocation, this.accountCreationSetting, this.accountCreators, this.projectCreationSetting, this.projectCreators, this.projectUploadSetting, this.projectUploaders, this.notificationEmailsSetting, this.maxUploadSize});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApplicationSettings)) {
            return false;
        }
        ApplicationSettings other = (ApplicationSettings)obj;
        return this.applicationName.equals(other.applicationName) && this.systemNotificationEmailAddress.equals(other.systemNotificationEmailAddress) && this.applicationLocation.equals(other.applicationLocation) && this.accountCreationSetting == other.accountCreationSetting && this.accountCreators.equals(other.accountCreators) && this.projectCreationSetting == other.projectCreationSetting && this.projectCreators.equals(other.projectCreators) && this.projectUploadSetting == other.projectUploadSetting && this.projectUploaders.equals(other.projectUploaders) && this.notificationEmailsSetting == other.notificationEmailsSetting && this.maxUploadSize == other.maxUploadSize;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ApplicationSettings").add("name", (Object)this.applicationName).add("systemNotificationEmail", (Object)this.systemNotificationEmailAddress).addValue((Object)this.applicationLocation).addValue((Object)this.accountCreationSetting).add("accountCreators", this.accountCreators).addValue((Object)this.projectCreationSetting).add("projectCreators", this.projectCreators).addValue(this.projectUploaders).add("projectUploaders", this.projectUploaders).addValue((Object)this.notificationEmailsSetting).toString();
    }
}

