/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.crud;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.criteria.CompositeHierarchyPositionCriteria;
import edu.stanford.protege.webprotege.criteria.CompositeRootCriteria;
import edu.stanford.protege.webprotege.criteria.EntityIsCriteria;
import edu.stanford.protege.webprotege.criteria.EntityIsNotCriteria;
import edu.stanford.protege.webprotege.criteria.EntityTypeIsOneOfCriteria;
import edu.stanford.protege.webprotege.criteria.HierarchyFilterType;
import edu.stanford.protege.webprotege.criteria.HierarchyPositionCriteria;
import edu.stanford.protege.webprotege.criteria.HierarchyPositionCriteriaVisitor;
import edu.stanford.protege.webprotege.criteria.InstanceOfCriteria;
import edu.stanford.protege.webprotege.criteria.IsLeafClassCriteria;
import edu.stanford.protege.webprotege.criteria.MultiMatchType;
import edu.stanford.protege.webprotege.criteria.NotSubClassOfCriteria;
import edu.stanford.protege.webprotege.criteria.RootCriteria;
import edu.stanford.protege.webprotege.criteria.SubClassOfCriteria;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;

public class EntityIriPrefixCriteriaRewriter {
    private static final HierarchyPositionCriteriaRewriterVisitor rewriter = new HierarchyPositionCriteriaRewriterVisitor();

    @Inject
    public EntityIriPrefixCriteriaRewriter() {
    }

    @Nonnull
    public RootCriteria rewriteCriteria(@Nonnull HierarchyPositionCriteria criteria) {
        return (RootCriteria)criteria.accept((HierarchyPositionCriteriaVisitor)rewriter);
    }

    private static class HierarchyPositionCriteriaRewriterVisitor
    implements HierarchyPositionCriteriaVisitor<RootCriteria> {
        private HierarchyPositionCriteriaRewriterVisitor() {
        }

        public RootCriteria visit(CompositeHierarchyPositionCriteria criteria) {
            ImmutableList rewrittenCriteria = (ImmutableList)criteria.getCriteria().stream().map(c -> (RootCriteria)c.accept((HierarchyPositionCriteriaVisitor)this)).collect(ImmutableList.toImmutableList());
            return CompositeRootCriteria.get((List)rewrittenCriteria, (MultiMatchType)criteria.getMatchType());
        }

        public RootCriteria visit(SubClassOfCriteria subClassOfCriteria) {
            OWLClass targetEntity = subClassOfCriteria.getTarget();
            EntityIsCriteria entityIsCriteria = EntityIsCriteria.get((OWLEntity)targetEntity);
            ImmutableList combinedCriteria = ImmutableList.of((Object)entityIsCriteria, (Object)subClassOfCriteria);
            return CompositeRootCriteria.get((List)combinedCriteria, (MultiMatchType)MultiMatchType.ANY);
        }

        public RootCriteria visit(InstanceOfCriteria instanceOfCriteria) {
            SubClassOfCriteria subClassOfCriteria = SubClassOfCriteria.get((OWLClass)instanceOfCriteria.getTarget(), (HierarchyFilterType)instanceOfCriteria.getFilterType());
            return (RootCriteria)subClassOfCriteria.accept((HierarchyPositionCriteriaVisitor)this);
        }

        public RootCriteria visit(NotSubClassOfCriteria notSubClassOfCriteria) {
            OWLClass targetEntity = notSubClassOfCriteria.getTarget();
            EntityIsNotCriteria entityIsNotCriteria = EntityIsNotCriteria.get((OWLEntity)targetEntity);
            ImmutableList combinedCriteria = ImmutableList.of((Object)entityIsNotCriteria, (Object)notSubClassOfCriteria);
            return CompositeRootCriteria.get((List)combinedCriteria, (MultiMatchType)MultiMatchType.ALL);
        }

        public RootCriteria visit(IsLeafClassCriteria isALeafClassCriteria) {
            return EntityTypeIsOneOfCriteria.get((ImmutableSet)ImmutableSet.of((Object)EntityType.CLASS));
        }
    }
}

