/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.criteria.CompositeRootCriteria;
import edu.stanford.protege.webprotege.search.SearchType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.EntityType;

public class EntityLookupRequest
implements Serializable {
    public static final int DEFAULT_MATCH_LIMIT = 20;
    @Nullable
    private CompositeRootCriteria entityMatchCriteria;
    private String searchString;
    private SearchType searchType = SearchType.getDefault();
    private ImmutableSet<EntityType<?>> searchedEntityTypes = ImmutableSet.of();
    private int searchLimit = 20;

    private EntityLookupRequest() {
    }

    public EntityLookupRequest(String searchString) {
        this(searchString, SearchType.getDefault());
    }

    public EntityLookupRequest(String searchString, SearchType searchType) {
        this(searchString, searchType, 20, EntityType.values(), null);
    }

    public EntityLookupRequest(String searchString, SearchType searchType, int searchLimit, Collection<EntityType<?>> searchedEntityTypes, @Nullable CompositeRootCriteria entityMatchCriteria) {
        this.searchString = (String)Preconditions.checkNotNull((Object)searchString);
        this.searchType = (SearchType)((Object)Preconditions.checkNotNull((Object)((Object)searchType)));
        if (searchLimit < 0) {
            throw new IllegalArgumentException("Search limit must not be less than zero");
        }
        this.searchLimit = searchLimit;
        this.entityMatchCriteria = entityMatchCriteria;
        this.searchedEntityTypes = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(searchedEntityTypes)));
    }

    public String getSearchString() {
        return this.searchString;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public int getSearchLimit() {
        return this.searchLimit;
    }

    public boolean isSearchType(EntityType<?> type) {
        return this.searchedEntityTypes.contains(type);
    }

    public Set<EntityType<?>> getSearchedEntityTypes() {
        return this.searchedEntityTypes;
    }

    @Nonnull
    public Optional<CompositeRootCriteria> getEntityMatchCriteria() {
        return Optional.ofNullable(this.entityMatchCriteria);
    }

    public int hashCode() {
        return "EntityLookupRequest".hashCode() + this.searchString.hashCode() + this.searchedEntityTypes.hashCode() + this.searchType.hashCode() + this.searchLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityLookupRequest)) {
            return false;
        }
        EntityLookupRequest other = (EntityLookupRequest)o;
        return this.searchString.equals(other.searchString) && this.searchedEntityTypes.equals(other.searchedEntityTypes) && this.searchType.equals((Object)other.searchType) && this.searchLimit == other.searchLimit;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EntityLookupRequest").add("searchString", (Object)this.searchString).add("searchType", (Object)this.searchType).add("searchedEntityTypes", this.searchedEntityTypes).add("searchLimit", this.searchLimit).toString();
    }
}

