/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class EventTag
implements Serializable,
Comparable<EventTag> {
    private static final EventTag FIRST = new EventTag(0);
    private int ordinal;

    private EventTag() {
    }

    @JsonCreator
    private EventTag(int ordinal) {
        this.ordinal = ordinal;
    }

    public static EventTag getFirst() {
        return FIRST;
    }

    public static EventTag get(int index) {
        return new EventTag(index);
    }

    public EventTag next() {
        return EventTag.get(this.ordinal + 1);
    }

    @JsonValue
    public int getOrdinal() {
        return this.ordinal;
    }

    public boolean isGreaterOrEqualTo(EventTag tag) {
        return this.ordinal >= tag.ordinal;
    }

    public int hashCode() {
        return "EventManagerTag".hashCode() + this.ordinal;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EventTag)) {
            return false;
        }
        EventTag other = (EventTag)obj;
        return this.ordinal == other.ordinal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EventTag");
        sb.append("(");
        sb.append(this.ordinal);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(EventTag o) {
        return this.ordinal - o.ordinal;
    }
}

