/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.issues;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.issues.Comment;
import edu.stanford.protege.webprotege.issues.Status;
import edu.stanford.protege.webprotege.issues.ThreadId;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLEntity;

public class EntityDiscussionThread {
    public static final String PROJECT_ID = "projectId";
    public static final String STATUS = "status";
    public static final String COMMENTS = "comments";
    public static final String COMMENTS_ID = "comments._id";
    public static final String ENTITY = "term";
    private ThreadId id;
    private ProjectId projectId;
    private OWLEntity entity;
    private Status status;
    private List<Comment> comments;

    @JsonCreator
    public EntityDiscussionThread(@JsonProperty(value="id") @Nonnull ThreadId id, @JsonProperty(value="projectId") @Nonnull ProjectId projectId, @JsonProperty(value="entity") @Nonnull OWLEntity entity, @JsonProperty(value="status") @Nonnull Status status, @JsonProperty(value="comments") @Nonnull ImmutableList<Comment> comments) {
        this.id = (ThreadId)Preconditions.checkNotNull((Object)id);
        this.projectId = (ProjectId)Preconditions.checkNotNull((Object)projectId);
        this.entity = (OWLEntity)Preconditions.checkNotNull((Object)entity);
        this.comments = (List)Preconditions.checkNotNull(comments);
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status)));
    }

    private EntityDiscussionThread() {
    }

    public ProjectId getProjectId() {
        return this.projectId;
    }

    public ThreadId getId() {
        return this.id;
    }

    @Nonnull
    public OWLEntity getEntity() {
        return this.entity;
    }

    @Nonnull
    public Status getStatus() {
        return this.status;
    }

    @Nonnull
    public ImmutableList<Comment> getComments() {
        return ImmutableList.copyOf(this.comments);
    }

    public boolean isCreatedBy(UserId userId) {
        return !this.comments.isEmpty() && this.comments.get(0).getCreatedBy().equals((Object)userId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.entity, this.comments, this.status});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityDiscussionThread)) {
            return false;
        }
        EntityDiscussionThread other = (EntityDiscussionThread)obj;
        return this.id.equals(other.id) && this.entity.equals(other.entity) && this.comments.equals(other.comments) && this.status.equals((Object)other.status);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EntityCommentsThread").addValue((Object)this.id).add(ENTITY, (Object)this.entity).add(STATUS, (Object)this.status).add(COMMENTS, this.comments).toString();
    }
}

