/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.issues;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.issues.Comment;
import edu.stanford.protege.webprotege.issues.LockSetting;
import edu.stanford.protege.webprotege.issues.Mention;
import edu.stanford.protege.webprotege.issues.Milestone;
import edu.stanford.protege.webprotege.issues.Status;
import edu.stanford.protege.webprotege.issues.events.IssueEvent;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLEntity;

public class Issue {
    @Nonnull
    private ProjectId projectId;
    private int number;
    @Nonnull
    private UserId creator;
    private long createdAt;
    @Nullable
    private Long updatedAt;
    @Nonnull
    private List<OWLEntity> targetEntities;
    @Nonnull
    private String title;
    @Nonnull
    private String body;
    @Nonnull
    private Status status;
    @Nonnull
    private List<UserId> assignees;
    @Nullable
    private Milestone milestone;
    @Nonnull
    private LockSetting lockSetting;
    @Nonnull
    private List<String> labels;
    @Nonnull
    private List<Comment> comments;
    @Nonnull
    private List<Mention> mentions;
    @Nonnull
    private List<UserId> participants;
    @Nonnull
    private List<IssueEvent> events;

    public Issue(@Nonnull ProjectId projectId, int number, @Nonnull UserId creator, long createdAt, @Nonnull Optional<Long> updatedAt, @Nonnull ImmutableList<OWLEntity> targetEntities, @Nonnull String title, @Nonnull String body, @Nonnull Status status, @Nonnull ImmutableList<UserId> assignees, @Nonnull Optional<Milestone> milestone, @Nonnull LockSetting lockSetting, @Nonnull ImmutableList<String> labels, @Nonnull ImmutableList<Comment> comments, @Nonnull ImmutableList<Mention> mentions, ImmutableList<UserId> participants, @Nonnull ImmutableList<IssueEvent> events) {
        this.projectId = (ProjectId)Preconditions.checkNotNull((Object)projectId);
        this.number = number;
        this.creator = (UserId)Preconditions.checkNotNull((Object)creator);
        this.createdAt = createdAt;
        this.updatedAt = ((Optional)Preconditions.checkNotNull(updatedAt)).orElse(null);
        this.targetEntities = (List)Preconditions.checkNotNull(targetEntities);
        this.title = (String)Preconditions.checkNotNull((Object)title);
        this.body = (String)Preconditions.checkNotNull((Object)body);
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this.assignees = (List)Preconditions.checkNotNull(assignees);
        this.milestone = ((Optional)Preconditions.checkNotNull(milestone)).orElse(null);
        this.lockSetting = (LockSetting)((Object)Preconditions.checkNotNull((Object)((Object)lockSetting)));
        this.labels = (List)Preconditions.checkNotNull(labels);
        this.mentions = (List)Preconditions.checkNotNull(mentions);
        this.events = (List)Preconditions.checkNotNull(events);
        this.participants = (List)Preconditions.checkNotNull(participants);
        this.comments = (List)Preconditions.checkNotNull(comments);
    }

    protected Issue(@Nonnull ProjectId projectId, int number, @Nonnull UserId creator, long createdAt, @Nullable Long updatedAt, @Nonnull List<OWLEntity> targetEntities, @Nonnull String title, @Nonnull String body, @Nonnull Status status, @Nonnull List<UserId> assignees, @Nullable Milestone milestone, @Nonnull LockSetting lockSetting, @Nonnull List<String> labels, @Nonnull List<Comment> comments, @Nonnull List<Mention> mentions, @Nonnull List<UserId> participants, @Nonnull List<IssueEvent> events) {
        this.projectId = (ProjectId)Preconditions.checkNotNull((Object)projectId);
        this.number = number;
        this.creator = (UserId)Preconditions.checkNotNull((Object)creator);
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.targetEntities = ImmutableList.copyOf(targetEntities);
        this.title = (String)Preconditions.checkNotNull((Object)title);
        this.body = (String)Preconditions.checkNotNull((Object)body);
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this.assignees = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(assignees)));
        this.milestone = milestone;
        this.lockSetting = (LockSetting)((Object)Preconditions.checkNotNull((Object)((Object)lockSetting)));
        this.labels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(labels)));
        this.comments = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(comments)));
        this.mentions = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(mentions)));
        this.participants = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(participants)));
        this.events = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(events)));
    }

    private Issue() {
    }

    @Nonnull
    public ProjectId getProjectId() {
        return this.projectId;
    }

    public int getNumber() {
        return this.number;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public String getBody() {
        return this.body;
    }

    @Nonnull
    public UserId getCreator() {
        return this.creator;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public Optional<Long> getUpdatedAt() {
        return Optional.ofNullable(this.updatedAt);
    }

    @Nonnull
    public ImmutableList<OWLEntity> getTargetEntities() {
        return ImmutableList.copyOf(this.targetEntities);
    }

    @Nonnull
    public Status getStatus() {
        return this.status;
    }

    @Nonnull
    public ImmutableList<UserId> getAssignees() {
        return ImmutableList.copyOf(this.assignees);
    }

    @Nonnull
    public Optional<Milestone> getMilestone() {
        return Optional.ofNullable(this.milestone);
    }

    @Nonnull
    public ImmutableList<String> getLabels() {
        return ImmutableList.copyOf(this.labels);
    }

    @Nonnull
    public ImmutableList<Comment> getComments() {
        return ImmutableList.copyOf(this.comments);
    }

    @Nonnull
    public ImmutableList<Mention> getMentions() {
        return ImmutableList.copyOf(this.mentions);
    }

    @Nonnull
    public List<UserId> getParticipants() {
        return ImmutableList.copyOf(this.participants);
    }

    @Nonnull
    public LockSetting getLockSetting() {
        return this.lockSetting;
    }

    @Nonnull
    public List<IssueEvent> getEvents() {
        return ImmutableList.copyOf(this.events);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectId, this.number, this.title, this.body, this.creator, this.createdAt, this.updatedAt, this.status, this.assignees, this.milestone, this.lockSetting, this.labels, this.events, this.participants, this.comments});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Issue)) {
            return false;
        }
        Issue other = (Issue)obj;
        return this.projectId.equals((Object)other.projectId) && this.number == other.number && this.title.equals(other.title) && this.body.equals(other.body) && this.creator.equals((Object)other.creator) && this.createdAt == other.createdAt && Objects.equal((Object)this.updatedAt, (Object)other.updatedAt) && this.targetEntities.equals(other.targetEntities) && this.status == other.status && this.assignees.equals(other.assignees) && Objects.equal((Object)this.milestone, (Object)other.milestone) && this.lockSetting.equals((Object)other.lockSetting) && this.labels.equals(other.labels) && this.comments.equals(other.comments) && this.mentions.equals(other.mentions) && this.participants.equals(other.participants) && this.events.equals(other.events);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IssueRecord").addValue((Object)this.projectId).add("number", this.number).add("owner", (Object)this.creator).add("createdAt", this.createdAt).add("updatedAt", (Object)this.updatedAt).add("targetEntities", this.targetEntities).addValue((Object)this.status).add("assignees", this.assignees).add("milestone", (Object)this.milestone).add("locked", (Object)this.lockSetting).add("labels", this.labels).add("body", (Object)this.body).add("comments", this.comments).add("mentions", this.mentions).add("participants", this.participants).add("events", this.events).toString();
    }
}

