/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.obo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.entity.OWLClassData;
import edu.stanford.protege.webprotege.entity.OWLObjectPropertyData;
import edu.stanford.protege.webprotege.entity.OWLPrimitiveData;
import java.io.Serializable;

public class OBORelationship
implements Serializable,
Comparable<OBORelationship> {
    private OWLObjectPropertyData relation;
    private OWLClassData value;

    private OBORelationship() {
    }

    public OBORelationship(OWLObjectPropertyData relation, OWLClassData value) {
        this.relation = (OWLObjectPropertyData)Preconditions.checkNotNull((Object)relation);
        this.value = (OWLClassData)Preconditions.checkNotNull((Object)value);
    }

    public OWLObjectPropertyData getRelation() {
        return this.relation;
    }

    public OWLClassData getValue() {
        return this.value;
    }

    @Override
    public int compareTo(OBORelationship o) {
        int diff = this.relation.compareTo((OWLPrimitiveData)o.getRelation());
        if (diff != 0) {
            return diff;
        }
        return this.value.compareTo((OWLPrimitiveData)o.getValue());
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OBORelationship").addValue((Object)this.relation).addValue((Object)this.value).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.relation, this.value});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OBORelationship)) {
            return false;
        }
        OBORelationship other = (OBORelationship)obj;
        return this.relation.equals(other.relation) && this.value.equals(other.value);
    }
}

