/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.obo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.entity.OWLClassData;
import edu.stanford.protege.webprotege.obo.OBOTermRelationships;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;

public class OBOTermCrossProduct
implements Serializable {
    @Nullable
    private OWLClassData genus;
    private OBOTermRelationships relationships;

    private OBOTermCrossProduct() {
    }

    public static OBOTermCrossProduct emptyOBOTermCrossProduct() {
        return new OBOTermCrossProduct(Optional.empty(), new OBOTermRelationships(Collections.emptySet()));
    }

    public OBOTermCrossProduct(Optional<OWLClassData> genus, OBOTermRelationships relationships) {
        this.genus = ((Optional)Preconditions.checkNotNull(genus)).orElse(null);
        this.relationships = (OBOTermRelationships)Preconditions.checkNotNull((Object)relationships);
    }

    public Optional<OWLClassData> getGenus() {
        return Optional.ofNullable(this.genus);
    }

    public OBOTermRelationships getRelationships() {
        return this.relationships;
    }

    public boolean isEmpty() {
        return this.genus == null || this.relationships.isEmpty();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.genus, this.relationships});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OBOTermCrossProduct)) {
            return false;
        }
        OBOTermCrossProduct other = (OBOTermCrossProduct)obj;
        return Objects.equal((Object)this.genus, (Object)other.genus) && this.relationships.equals(other.relationships);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OBOTermCrossProduct").addValue((Object)this.genus).addValue((Object)this.relationships).toString();
    }
}

