/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.obo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.obo.OBOTermMetaData;
import edu.stanford.protege.webprotege.obo.OBOXRef;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class OBOTermDefinition
extends OBOTermMetaData
implements Serializable {
    public static final OBOTermDefinition EMPTY = new OBOTermDefinition(Collections.emptyList(), "");
    private String definition;

    private OBOTermDefinition() {
    }

    public static OBOTermDefinition empty() {
        return EMPTY;
    }

    public OBOTermDefinition(List<OBOXRef> xrefs, String definition) {
        super(xrefs);
        this.definition = (String)Preconditions.checkNotNull((Object)definition);
    }

    public String getDefinition() {
        return this.definition;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.definition, this.getXRefs()});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OBOTermDefinition)) {
            return false;
        }
        OBOTermDefinition other = (OBOTermDefinition)obj;
        return this.definition.equals(other.definition) && this.getXRefs().equals(other.getXRefs());
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OBOTermDefinition").add("definition", (Object)this.definition).addValue(this.getXRefs()).toString();
    }
}

