/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.perspective;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import edu.stanford.protege.webprotege.perspective.NodePropertyValue;
import edu.stanford.protege.webprotege.perspective.NodePropertyValueMap;
import edu.stanford.protege.webprotege.perspective.StringNodePropertyValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NodeProperties {
    private static final NodeProperties EMPTY_NODE_PROPERTIES = new NodeProperties(Collections.emptyMap());
    private final Map<String, NodePropertyValue> properties = new HashMap<String, NodePropertyValue>();

    @JsonCreator
    private NodeProperties(@Nullable Map<String, NodePropertyValue> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static NodeProperties emptyNodeProperties() {
        return EMPTY_NODE_PROPERTIES;
    }

    public String getPropertyValue(String propertyName, String defaultValue) {
        NodePropertyValue value = this.properties.get(propertyName);
        if (value instanceof StringNodePropertyValue) {
            return ((StringNodePropertyValue)value).getValue();
        }
        return defaultValue;
    }

    public NodePropertyValue getPropertyValue(String propertyName, NodePropertyValue defaultValue) {
        NodePropertyValue value = this.properties.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @JsonValue
    public NodePropertyValueMap getPropertiesAsMap() {
        return new NodePropertyValueMap(this.properties);
    }

    @JsonIgnore
    @Nonnull
    public List<String> getProperties() {
        return new ArrayList<String>(this.properties.keySet());
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this.properties);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NodeProperties");
        for (String property : this.properties.keySet()) {
            helper.add(property, (Object)this.properties.get(property));
        }
        return helper.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeProperties)) {
            return false;
        }
        NodeProperties other = (NodeProperties)obj;
        return this.properties.equals(other.properties);
    }

    public static class Builder {
        @Nonnull
        private final Map<String, NodePropertyValue> propertiesMap;

        public Builder() {
            this(new LinkedHashMap<String, NodePropertyValue>());
        }

        public Builder(@Nonnull Map<String, NodePropertyValue> propertiesMap) {
            this.propertiesMap = propertiesMap;
        }

        @Nonnull
        public Builder setValue(String property, NodePropertyValue value) {
            this.propertiesMap.put(property, value);
            return this;
        }

        @Nonnull
        public Builder setValue(String property, String value) {
            this.setValue(property, StringNodePropertyValue.get(value));
            return this;
        }

        public NodeProperties build() {
            if (this.propertiesMap.isEmpty()) {
                return EMPTY_NODE_PROPERTIES;
            }
            return new NodeProperties(new LinkedHashMap<String, NodePropertyValue>(this.propertiesMap));
        }
    }
}

