/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.perspective;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.LanguageMap;
import edu.stanford.protege.webprotege.perspective.AutoValue_PerspectiveDescriptor;
import edu.stanford.protege.webprotege.perspective.PerspectiveId;
import javax.annotation.Nonnull;

@AutoValue
public abstract class PerspectiveDescriptor {
    public static final String PERSPECTIVE_ID = "perspectiveId";
    public static final String LABEL = "label";
    public static final String FAVORITE = "favorite";

    @JsonCreator
    @Nonnull
    public static PerspectiveDescriptor get(@JsonProperty(value="perspectiveId") @Nonnull PerspectiveId perspectiveId, @JsonProperty(value="label") @Nonnull LanguageMap newLabel, @JsonProperty(value="favorite") boolean favorite) {
        return new AutoValue_PerspectiveDescriptor(perspectiveId, newLabel, favorite);
    }

    @JsonProperty(value="perspectiveId")
    @Nonnull
    public abstract PerspectiveId getPerspectiveId();

    @JsonProperty(value="label")
    @Nonnull
    public abstract LanguageMap getLabel();

    @JsonProperty(value="favorite")
    public abstract boolean isFavorite();

    @Nonnull
    public PerspectiveDescriptor withFavorite(boolean favorite) {
        if (favorite == this.isFavorite()) {
            return this;
        }
        return PerspectiveDescriptor.get(this.getPerspectiveId(), this.getLabel(), favorite);
    }
}

