/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.ShortForm;
import edu.stanford.protege.webprotege.entity.EntityNode;
import edu.stanford.protege.webprotege.search.AutoValue_SearchResultMatch;
import edu.stanford.protege.webprotege.search.SearchResultMatchPosition;
import javax.annotation.Nonnull;

@AutoValue
public abstract class SearchResultMatch {
    public static final String ENTITY = "term";
    public static final String LANGUAGE = "language";
    public static final String VALUE = "value";
    public static final String POSITIONS = "positions";

    @JsonCreator
    public static SearchResultMatch get(@JsonProperty(value="term") @Nonnull EntityNode entity, @JsonProperty(value="language") @Nonnull DictionaryLanguage matchedDictionaryLanguage, @JsonProperty(value="value") @Nonnull String matchedString, @JsonProperty(value="positions") @Nonnull ImmutableList<SearchResultMatchPosition> searchResultMatchPositions) {
        return new AutoValue_SearchResultMatch(entity, matchedDictionaryLanguage, matchedString, searchResultMatchPositions);
    }

    @JsonProperty(value="term")
    @Nonnull
    public abstract EntityNode getEntity();

    @JsonProperty(value="language")
    @Nonnull
    public abstract DictionaryLanguage getLanguage();

    @JsonIgnore
    @Nonnull
    public ImmutableMap<DictionaryLanguage, String> getLanguageRendering() {
        return this.getEntity().getShortForms();
    }

    @JsonIgnore
    public ImmutableList<ShortForm> getShortForms() {
        return this.getEntity().getShortFormsList();
    }

    @JsonProperty(value="value")
    @Nonnull
    public abstract String getValue();

    @JsonProperty(value="positions")
    @Nonnull
    public abstract ImmutableList<SearchResultMatchPosition> getPositions();
}

