/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.sharing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.sharing.SharingPermission;
import edu.stanford.protege.webprotege.sharing.SharingSetting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class ProjectSharingSettings
implements Serializable {
    private final ProjectId projectId;
    private final List<SharingSetting> sharingSettings = new ArrayList<SharingSetting>();
    @Nullable
    private SharingPermission linkSharingPermission = null;

    @JsonCreator
    public ProjectSharingSettings(@JsonProperty(value="projectId") ProjectId projectId, @JsonProperty(value="linkSharingPermission") Optional<SharingPermission> linkSharingPermission, @JsonProperty(value="sharingSettings") List<SharingSetting> sharingSettings) {
        this.projectId = (ProjectId)Preconditions.checkNotNull((Object)projectId);
        this.sharingSettings.addAll((Collection)Preconditions.checkNotNull(sharingSettings));
        this.linkSharingPermission = ((Optional)Preconditions.checkNotNull(linkSharingPermission)).orElse(null);
    }

    public ProjectId getProjectId() {
        return this.projectId;
    }

    public List<SharingSetting> getSharingSettings() {
        return new ArrayList<SharingSetting>(this.sharingSettings);
    }

    public Optional<SharingPermission> getLinkSharingPermission() {
        return Optional.ofNullable(this.linkSharingPermission);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectId, this.linkSharingPermission, this.sharingSettings});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProjectSharingSettings)) {
            return false;
        }
        ProjectSharingSettings other = (ProjectSharingSettings)obj;
        return other.projectId.equals((Object)this.projectId) && Objects.equal((Object)this.linkSharingPermission, (Object)other.linkSharingPermission) && other.sharingSettings.equals(this.sharingSettings);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ProjectSharingSettings").addValue((Object)this.projectId).addValue(this.sharingSettings).toString();
    }
}

