/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.sharing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.sharing.PersonId;
import edu.stanford.protege.webprotege.sharing.SharingPermission;
import java.io.Serializable;

public class SharingSetting
implements Comparable<SharingSetting>,
Serializable {
    private PersonId personId;
    private SharingPermission sharingPermission;

    private SharingSetting() {
    }

    @JsonCreator
    public SharingSetting(@JsonProperty(value="personId") PersonId personId, @JsonProperty(value="sharingPermission") SharingPermission sharingPermission) {
        this.personId = (PersonId)Preconditions.checkNotNull((Object)personId);
        this.sharingPermission = (SharingPermission)Preconditions.checkNotNull((Object)sharingPermission);
    }

    public PersonId getPersonId() {
        return this.personId;
    }

    public SharingPermission getSharingPermission() {
        return this.sharingPermission;
    }

    @Override
    public int compareTo(SharingSetting o) {
        return this.personId.compareTo(o.personId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UserSharingSetting").addValue((Object)this.personId).addValue((Object)this.sharingPermission).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.personId, this.sharingPermission});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SharingSetting)) {
            return false;
        }
        SharingSetting other = (SharingSetting)obj;
        return this.personId.equals(other.personId) && this.sharingPermission.equals(other.sharingPermission);
    }
}

