/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.UserId;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;

public class UserDetails
implements Serializable {
    private static final String GUEST_DISPLAY_NAME = "Guest";
    private static final UserDetails GUEST_DETAILS = new UserDetails(UserId.getGuest(), "Guest", Optional.empty());
    private final UserId userId;
    private final String displayName;
    private final String emailAddress;

    public UserDetails(@Nonnull UserId userId, @Nonnull String displayName, @Nonnull Optional<String> emailAddress) {
        this.userId = (UserId)Preconditions.checkNotNull((Object)userId);
        this.displayName = (String)Preconditions.checkNotNull((Object)displayName);
        this.emailAddress = emailAddress.orElse(null);
    }

    @Nonnull
    public static UserDetails getUserDetails(@Nonnull UserId userId, @Nonnull String displayName, @Nonnull String emailAddress) {
        return new UserDetails(userId, displayName, Optional.of(emailAddress));
    }

    @Nonnull
    @JsonCreator
    public static UserDetails getUserDetails(@JsonProperty(value="userId") @Nonnull UserId userId, @JsonProperty(value="displayName") @Nonnull String displayName, @JsonProperty(value="emailAddress") @Nonnull Optional<String> emailAddress) {
        return new UserDetails(userId, displayName, emailAddress);
    }

    @Nonnull
    public static UserDetails getGuestUserDetails() {
        return GUEST_DETAILS;
    }

    @Nonnull
    public UserId getUserId() {
        return this.userId;
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    @Nonnull
    public Optional<String> getEmailAddress() {
        return Optional.ofNullable(this.emailAddress);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.userId, this.displayName, this.emailAddress});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UserDetails)) {
            return false;
        }
        UserDetails other = (UserDetails)obj;
        return this.userId.equals((Object)other.userId) && this.displayName.equals(other.displayName) && this.getEmailAddress().equals(other.getEmailAddress());
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UserDetails").addValue((Object)this.userId).add("displayName", (Object)this.displayName).add("emailAddress", (Object)Optional.ofNullable(this.emailAddress).orElse("")).toString();
    }
}

