/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.viz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import edu.stanford.protege.webprotege.entity.OWLEntityData;
import edu.stanford.protege.webprotege.viz.AutoValue_EntityGraph;
import edu.stanford.protege.webprotege.viz.Edge;
import edu.stanford.protege.webprotege.viz.RelationshipEdge;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLEntity;

@AutoValue
public abstract class EntityGraph {
    @JsonCreator
    @Nonnull
    public static EntityGraph create(@JsonProperty(value="root") OWLEntityData root, @JsonProperty(value="edges") ImmutableSet<Edge> edges, @JsonProperty(value="prunedToEdgeLimit") boolean isPrunedToEdgeLimit) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSetMultimap.Builder edgesByTailNode = ImmutableSetMultimap.builder();
        builder.add((Object)root);
        edges.forEach(e -> {
            builder.add((Object)e.getTail());
            builder.add((Object)e.getHead());
            edgesByTailNode.put((Object)e.getTail(), e);
        });
        ImmutableSet nodes = builder.build();
        return new AutoValue_EntityGraph(root, nodes.size(), (ImmutableSet<OWLEntityData>)nodes, edges.size(), edges, isPrunedToEdgeLimit, (ImmutableSetMultimap<OWLEntityData, Edge>)edgesByTailNode.build());
    }

    @Nonnull
    public abstract OWLEntityData getRoot();

    @JsonIgnore
    public abstract int getNodeCount();

    @JsonIgnore
    @Nonnull
    public abstract ImmutableSet<OWLEntityData> getNodes();

    @JsonIgnore
    public abstract int getEdgeCount();

    @Nonnull
    public abstract ImmutableSet<Edge> getEdges();

    @JsonIgnore
    @Nonnull
    public OWLEntity getRootEntity() {
        return this.getRoot().getEntity();
    }

    public abstract boolean isPrunedToEdgeLimit();

    @JsonIgnore
    @Nonnull
    public abstract ImmutableSetMultimap<OWLEntityData, Edge> getEdgesByTailNode();

    @JsonIgnore
    public Set<OWLEntityData> getEdgeLabels() {
        if (this.getEdges().isEmpty()) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Edge edge : this.getEdges()) {
            edge.getLabellingEntity().ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    @JsonIgnore
    public ImmutableMultimap<OWLEntityData, String> getDescriptorsByTailNode() {
        ImmutableMultimap.Builder result = ImmutableMultimap.builder();
        for (Edge edge : this.getEdges()) {
            result.put((Object)edge.getTail(), (Object)edge.getRelationshipDescriptor());
        }
        return result.build();
    }

    @JsonIgnore
    public ImmutableMultimap<String, Edge> getEdgesByDescriptor() {
        ImmutableMultimap.Builder result = ImmutableMultimap.builder();
        for (Edge edge : this.getEdges()) {
            result.put((Object)edge.getRelationshipDescriptor(), (Object)edge);
        }
        return result.build();
    }

    @JsonIgnore
    public ImmutableSetMultimap<OWLEntityData, Edge> getEdgesByCluster(OWLEntity rootNode) {
        HashSet processed = new HashSet();
        ImmutableSetMultimap.Builder resultBuilder = ImmutableSetMultimap.builder();
        this.getEdges().forEach(e -> {
            HashSet<OWLEntityData> tailClusters = new HashSet<OWLEntityData>();
            HashSet<OWLEntityData> headClusters = new HashSet<OWLEntityData>();
            if (!rootNode.equals(e.getTail().getEntity())) {
                this.getIsAClusters(tailClusters, e.getTail(), new HashSet<OWLEntityData>());
                this.getIsAClusters(headClusters, e.getHead(), new HashSet<OWLEntityData>());
                if (tailClusters.equals(headClusters)) {
                    tailClusters.forEach(c -> resultBuilder.put(c, e));
                }
            }
        });
        return resultBuilder.build();
    }

    @JsonIgnore
    public Set<OWLEntityData> getTransitiveClosure(OWLEntityData from, Set<OWLEntityData> edgeFilter) {
        HashSet<OWLEntityData> nodes = new HashSet<OWLEntityData>();
        ImmutableSetMultimap<OWLEntityData, Edge> edgeMap = this.getEdgesByTailNode();
        this.getTransitiveClosure(from, (Set<OWLEntityData>)nodes, edgeFilter, (ImmutableMultimap<OWLEntityData, Edge>)edgeMap);
        return nodes;
    }

    private void getTransitiveClosure(@Nonnull OWLEntityData from, @Nonnull Set<OWLEntityData> nodes, @Nonnull Set<OWLEntityData> edgeFilter, @Nonnull ImmutableMultimap<OWLEntityData, Edge> edgesByTailNode) {
        if (nodes.contains(from)) {
            return;
        }
        nodes.add(from);
        ImmutableCollection edges = edgesByTailNode.get((Object)from);
        for (Edge edge : edges) {
            if (!this.isIncluded(edgeFilter, edge)) continue;
            this.getTransitiveClosure(edge.getHead(), nodes, edgeFilter, edgesByTailNode);
        }
    }

    private boolean isIncluded(@Nonnull Set<OWLEntityData> edgeFilter, Edge edge) {
        if (edge.isIsA()) {
            return true;
        }
        OWLEntityData rel = ((RelationshipEdge)edge).getRelationship();
        return edgeFilter.contains(rel);
    }

    private void getIsAClusters(Set<OWLEntityData> clutersBuilder, OWLEntityData node, Set<OWLEntityData> processed) {
        if (processed.contains(node)) {
            return;
        }
        processed.add(node);
        long isACount = this.getEdgesByTailNode().get((Object)node).stream().filter(Edge::isIsA).peek(e -> this.getIsAClusters(clutersBuilder, e.getHead(), processed)).count();
        if (isACount == 0L) {
            clutersBuilder.add(node);
        }
    }
}

