/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.viz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.criteria.MultiMatchType;
import edu.stanford.protege.webprotege.viz.AutoValue_EntityGraphSettings;
import edu.stanford.protege.webprotege.viz.CompositeEdgeCriteria;
import edu.stanford.protege.webprotege.viz.EdgeCriteria;
import edu.stanford.protege.webprotege.viz.EntityGraphFilter;
import edu.stanford.protege.webprotege.viz.FilterName;
import edu.stanford.protege.webprotege.viz.NegatedEdgeCriteria;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@AutoValue
public abstract class EntityGraphSettings {
    public static final String FILTERS = "filters";
    public static final String RANK_SPACING = "rankSpacing";

    @Nonnull
    public static EntityGraphSettings getDefault() {
        return EntityGraphSettings.get((ImmutableList<EntityGraphFilter>)ImmutableList.of(), 1.0);
    }

    @JsonCreator
    public static EntityGraphSettings get(@Nonnull @JsonProperty(value="filters") ImmutableList<EntityGraphFilter> criteria, @JsonProperty(value="rankSpacing", defaultValue="1.0") double rankSpacing) {
        return new AutoValue_EntityGraphSettings(criteria, rankSpacing);
    }

    @JsonIgnore
    @Nonnull
    public ImmutableList<FilterName> getActiveFilterNames() {
        return (ImmutableList)this.getFilters().stream().filter(EntityGraphFilter::isActive).map(EntityGraphFilter::getName).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    @JsonProperty(value="filters")
    public abstract ImmutableList<EntityGraphFilter> getFilters();

    @JsonIgnore
    @Nonnull
    public EdgeCriteria getCombinedActiveFilterCriteria() {
        List inclusionCriteria = this.getFilters().stream().filter(EntityGraphFilter::isActive).map(EntityGraphFilter::getInclusionCriteria).collect(Collectors.toList());
        List exclusionCriteria = this.getFilters().stream().filter(EntityGraphFilter::isActive).map(EntityGraphFilter::getExclusionCriteria).map(NegatedEdgeCriteria::get).collect(Collectors.toList());
        return CompositeEdgeCriteria.get(MultiMatchType.ALL, CompositeEdgeCriteria.get(inclusionCriteria, MultiMatchType.ANY), CompositeEdgeCriteria.get(exclusionCriteria, MultiMatchType.ALL));
    }

    @JsonIgnore
    @Nonnull
    public ImmutableSet<FilterName> getFilterNames() {
        return (ImmutableSet)this.getFilters().stream().map(EntityGraphFilter::getName).collect(ImmutableSet.toImmutableSet());
    }

    @JsonProperty(value="rankSpacing")
    public abstract double getRankSpacing();
}

