/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.viz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.project.HasProjectId;
import edu.stanford.protege.webprotege.viz.AutoValue_ProjectUserEntityGraphSettings;
import edu.stanford.protege.webprotege.viz.EntityGraphSettings;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class ProjectUserEntityGraphSettings
implements HasProjectId {
    public static final String PROJECT_ID = "projectId";
    public static final String USER_ID = "userId";
    private static final String SETTINGS = "settings";

    @JsonCreator
    public static ProjectUserEntityGraphSettings get(@Nonnull @JsonProperty(value="projectId") ProjectId projectId, @Nullable @JsonProperty(value="userId") UserId userId, @Nonnull @JsonProperty(value="settings") EntityGraphSettings settings) {
        return new AutoValue_ProjectUserEntityGraphSettings(projectId, userId, settings);
    }

    @Nonnull
    public static ProjectUserEntityGraphSettings getDefault(@Nonnull ProjectId projectId, @Nullable UserId userId) {
        return ProjectUserEntityGraphSettings.get(projectId, userId, EntityGraphSettings.getDefault());
    }

    @Override
    @JsonProperty(value="projectId")
    @Nonnull
    public abstract ProjectId projectId();

    @JsonProperty(value="userId")
    @Nullable
    public abstract UserId getUserIdInternal();

    @JsonProperty(value="settings")
    @Nonnull
    public abstract EntityGraphSettings getSettings();

    @JsonIgnore
    @Nullable
    public Optional<UserId> getUserId() {
        return Optional.ofNullable(this.getUserIdInternal());
    }
}

