/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.diff;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.diff.DiffOperation;
import java.io.Serializable;

public class DiffElement<S, E>
implements Serializable {
    private DiffOperation diffOperation;
    private S sourceDocument;
    private E lineElement;

    private DiffElement() {
    }

    public DiffElement(DiffOperation diffOperation, S sourceDocument, E lineElement) {
        this.diffOperation = (DiffOperation)((Object)Preconditions.checkNotNull((Object)((Object)diffOperation)));
        this.sourceDocument = Preconditions.checkNotNull(sourceDocument);
        this.lineElement = Preconditions.checkNotNull(lineElement);
    }

    public DiffOperation getDiffOperation() {
        return this.diffOperation;
    }

    public S getSourceDocument() {
        return this.sourceDocument;
    }

    public E getLineElement() {
        return this.lineElement;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.diffOperation, this.sourceDocument, this.lineElement});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DiffElement)) {
            return false;
        }
        DiffElement other = (DiffElement)obj;
        return this.diffOperation.equals((Object)other.diffOperation) && this.sourceDocument.equals(other.sourceDocument) && this.lineElement.equals(other.lineElement);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DiffElement").addValue((Object)this.diffOperation).add("sourceDocument", this.sourceDocument).add("lineElement", this.lineElement).toString();
    }
}

