/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.issues;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.ValueObject;
import java.util.UUID;
import javax.annotation.Nonnull;

public class ThreadId
implements ValueObject {
    private String id;

    @JsonCreator
    public ThreadId(@Nonnull String id) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
    }

    public static ThreadId create() {
        return new ThreadId(UUID.randomUUID().toString());
    }

    public static ThreadId valueOf(String id) {
        return new ThreadId(id);
    }

    private ThreadId() {
    }

    @JsonValue
    public String getId() {
        return this.id;
    }

    public String value() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ThreadId)) {
            return false;
        }
        ThreadId other = (ThreadId)obj;
        return this.id.equals(other.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ThreadId").addValue((Object)this.id).toString();
    }
}

